/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization.jackson;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.fluxcapacitor.common.api.SerializedObject;
import io.fluxcapacitor.javaclient.common.serialization.AbstractSerializer;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingObject;
import io.fluxcapacitor.javaclient.common.serialization.SerializationException;
import io.fluxcapacitor.javaclient.common.serialization.jackson.ObjectNodeConverter;
import io.fluxcapacitor.javaclient.common.serialization.upcasting.Upcaster;
import io.fluxcapacitor.javaclient.common.serialization.upcasting.UpcasterChain;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;

public class JacksonSerializer
extends AbstractSerializer {
    public static final ObjectMapper defaultObjectMapper = new ObjectMapper().findAndRegisterModules().disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private final ObjectMapper objectMapper;

    public JacksonSerializer() {
        this(Collections.emptyList());
    }

    public JacksonSerializer(Collection<?> upcasters) {
        this(defaultObjectMapper, upcasters);
    }

    public JacksonSerializer(ObjectMapper objectMapper) {
        this(objectMapper, Collections.emptyList());
    }

    public JacksonSerializer(ObjectMapper objectMapper, Collection<?> upcasters) {
        this(objectMapper, UpcasterChain.create(upcasters, new ObjectNodeConverter(objectMapper)));
    }

    public JacksonSerializer(ObjectMapper objectMapper, Upcaster<SerializedObject<byte[], ?>> upcasterChain) {
        super(upcasterChain);
        this.objectMapper = objectMapper;
    }

    @Override
    protected byte[] doSerialize(Object object) throws Exception {
        return this.objectMapper.writeValueAsBytes(object);
    }

    @Override
    protected Object doDeserialize(byte[] bytes, Class<?> type) throws Exception {
        return this.objectMapper.readValue(bytes, type);
    }

    @Override
    protected Stream<DeserializingObject<byte[], ?>> handleUnknownType(SerializedObject<byte[], ?> s) {
        return Stream.of(new DeserializingObject(s, () -> {
            try {
                return this.doDeserialize((byte[])s.data().getValue(), Object.class);
            }
            catch (Exception e) {
                throw new SerializationException(String.format("Could not deserialize a %s to a Map. Invalid Json?", s.data().getType()), e);
            }
        }));
    }
}

