/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fluxcapacitor.javaclient.common.serialization.SerializationException;
import io.fluxcapacitor.javaclient.common.serialization.upcasting.Converter;
import java.beans.ConstructorProperties;
import java.io.IOException;

public class ObjectNodeConverter
implements Converter<JsonNode> {
    private final ObjectMapper objectMapper;

    @Override
    public JsonNode convert(byte[] bytes) {
        try {
            return this.objectMapper.readTree(bytes);
        }
        catch (IOException e) {
            throw new SerializationException("Could not read JsonNode from byte[]", e);
        }
    }

    @Override
    public byte[] convertBack(JsonNode value) {
        try {
            return this.objectMapper.writeValueAsBytes((Object)value);
        }
        catch (JsonProcessingException e) {
            throw new SerializationException("Could not write byte[] from JsonNode: " + value, e);
        }
    }

    @Override
    public Class<JsonNode> getDataType() {
        return JsonNode.class;
    }

    @ConstructorProperties(value={"objectMapper"})
    public ObjectNodeConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

