/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.websocket;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.TimingUtils;
import io.fluxcapacitor.common.api.JsonType;
import io.fluxcapacitor.common.api.QueryResult;
import io.fluxcapacitor.common.api.Request;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebsocketClient
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(AbstractWebsocketClient.class);
    private final WebSocketContainer container;
    private final URI endpointUri;
    private final Duration reconnectDelay;
    private final Map<Long, WebSocketRequest> requests = new ConcurrentHashMap<Long, WebSocketRequest>();
    private final AtomicReference<Session> session = new AtomicReference();
    private final AtomicBoolean closed = new AtomicBoolean();

    public AbstractWebsocketClient(URI endpointUri) {
        this(ContainerProvider.getWebSocketContainer(), endpointUri, Duration.ofSeconds(1L));
    }

    public AbstractWebsocketClient(WebSocketContainer container, URI endpointUri, Duration reconnectDelay) {
        this.container = container;
        this.endpointUri = endpointUri;
        this.reconnectDelay = reconnectDelay;
    }

    protected Awaitable send(Object object) {
        this.getSession().getBasicRemote().sendObject(object);
        return Awaitable.ready();
    }

    protected <R extends QueryResult> R sendRequest(Request request) {
        WebSocketRequest webSocketRequest = new WebSocketRequest(request);
        this.requests.put(request.getRequestId(), webSocketRequest);
        try {
            webSocketRequest.send(this.getSession());
            return (R)webSocketRequest.getResult();
        }
        catch (Exception e) {
            this.requests.remove(request.getRequestId());
            throw new IllegalStateException("Failed to handle request " + request, e);
        }
    }

    @OnMessage
    public void onMessage(JsonType value) {
        QueryResult readResult = (QueryResult)value;
        WebSocketRequest webSocketRequest = this.requests.remove(readResult.getRequestId());
        if (webSocketRequest == null) {
            log.warn("Could not find outstanding read request for id {}", (Object)readResult.getRequestId());
        } else {
            webSocketRequest.complete(readResult);
        }
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        if (closeReason.getCloseCode().getCode() > CloseReason.CloseCodes.NO_STATUS_CODE.getCode()) {
            log.warn("Connection to endpoint {} closed with reason {}", (Object)session.getRequestURI(), (Object)closeReason);
        }
        this.retryOutstandingRequests(session.getId());
    }

    protected void retryOutstandingRequests(String sessionId) {
        if (!this.closed.get() && !this.requests.isEmpty()) {
            try {
                Thread.sleep(this.reconnectDelay.toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Thread interrupted while trying to retry outstanding requests", e);
            }
            this.requests.values().stream().filter(r -> sessionId.equals(r.getSessionId())).forEach(r -> {
                try {
                    r.send(this.getSession());
                }
                catch (Exception e) {
                    r.completeExceptionally(e);
                }
            });
        }
    }

    @OnError
    public void onError(Session session, Throwable e) {
        log.error("Client side error for web socket connected to endpoint {}", (Object)session.getRequestURI(), (Object)e);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            Session session = this.getSession();
            if (session != null) {
                try {
                    session.close();
                }
                catch (IOException e) {
                    log.warn("Failed to closed websocket session connected to endpoint {}. Reason: {}", (Object)session.getRequestURI(), (Object)e.getMessage());
                }
            }
            if (session != null && !this.requests.isEmpty()) {
                log.warn("Closed websocket session to endpoint {} with {} outstanding requests", (Object)session.getRequestURI(), (Object)this.requests.size());
            }
        }
    }

    protected Session getSession() {
        return this.session.updateAndGet(s -> {
            while (!this.closed.get() && !this.isOpen((Session)s)) {
                s = (Session)TimingUtils.retryOnFailure(() -> {
                    AtomicReference<Session> atomicReference = this.session;
                    synchronized (atomicReference) {
                        if (this.isOpen(this.session.get())) {
                            return this.session.get();
                        }
                        return this.container.connectToServer((Object)this, this.endpointUri);
                    }
                }, (Duration)this.reconnectDelay, e -> !this.closed.get());
            }
            return s;
        });
    }

    protected boolean isOpen(Session session) {
        return session != null && session.isOpen();
    }

    protected class WebSocketRequest {
        private final Request request;
        private final CompletableFuture<QueryResult> result = new CompletableFuture();
        private volatile String sessionId;

        protected void send(Session session) {
            this.sessionId = session.getId();
            AbstractWebsocketClient.this.send(this.request);
        }

        protected void completeExceptionally(Throwable e) {
            this.result.completeExceptionally(e);
        }

        protected void complete(QueryResult value) {
            this.result.complete(value);
        }

        public QueryResult getResult() throws ExecutionException, InterruptedException {
            return this.result.get();
        }

        @ConstructorProperties(value={"request"})
        public WebSocketRequest(Request request) {
            this.request = request;
        }

        public String getSessionId() {
            return this.sessionId;
        }
    }
}

