/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.websocket;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fluxcapacitor.common.api.JsonType;
import java.io.InputStream;
import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import javax.websocket.EndpointConfig;

public class JsonDecoder
implements Decoder.BinaryStream<JsonType> {
    private static final ObjectMapper defaultMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private final ObjectMapper objectMapper;

    public JsonDecoder() {
        this(defaultMapper);
    }

    public JsonDecoder(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public JsonType decode(InputStream is) throws DecodeException {
        try {
            return (JsonType)this.objectMapper.readValue(is, JsonType.class);
        }
        catch (Exception e) {
            throw new DecodeException("", "Could not parse input. Expected a Json message.", (Throwable)e);
        }
    }

    public void init(EndpointConfig config) {
    }

    public void destroy() {
    }
}

