/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.websocket;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.ServicePathBuilder;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;

public class ServiceUrlBuilder {
    public static String producerUrl(MessageType messageType, WebSocketClient.Properties clientProperties) {
        return ServiceUrlBuilder.buildUrl(clientProperties, ServicePathBuilder.producerPath((MessageType)messageType));
    }

    public static String consumerUrl(MessageType messageType, WebSocketClient.Properties clientProperties) {
        String url = ServiceUrlBuilder.buildUrl(clientProperties, ServicePathBuilder.consumerPath((MessageType)messageType));
        if (clientProperties.getTypeFilter() != null) {
            url = url + "&typeFilter=" + clientProperties.getTypeFilter();
        }
        return url;
    }

    public static String eventSourcingUrl(WebSocketClient.Properties clientProperties) {
        return ServiceUrlBuilder.buildUrl(clientProperties, ServicePathBuilder.eventSourcingPath());
    }

    public static String keyValueUrl(WebSocketClient.Properties clientProperties) {
        return ServiceUrlBuilder.buildUrl(clientProperties, ServicePathBuilder.keyValuePath());
    }

    public static String schedulingUrl(WebSocketClient.Properties clientProperties) {
        return ServiceUrlBuilder.buildUrl(clientProperties, ServicePathBuilder.schedulingPath());
    }

    private static String buildUrl(WebSocketClient.Properties clientProperties, String path) {
        if (clientProperties.getProjectId() != null) {
            return String.format("%s/%s?projectId=%s&clientId=%s&clientName=%s", clientProperties.getServiceBaseUrl(), path, clientProperties.getProjectId(), clientProperties.getId(), clientProperties.getName());
        }
        return String.format("%s/%s?clientId=%s&clientName=%s", clientProperties.getServiceBaseUrl(), path, clientProperties.getId(), clientProperties.getName());
    }
}

