/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.eventsourcing;

import io.fluxcapacitor.common.handling.HandlerInspector;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.handling.HandlerNotFoundException;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.eventsourcing.ApplyEvent;
import io.fluxcapacitor.javaclient.eventsourcing.EventSourcingHandler;
import io.fluxcapacitor.javaclient.eventsourcing.MessageParameterResolver;
import io.fluxcapacitor.javaclient.eventsourcing.MetadataParameterResolver;
import io.fluxcapacitor.javaclient.eventsourcing.PayloadParameterResolver;
import java.util.Arrays;
import java.util.List;

public class AnnotatedEventSourcingHandler<T>
implements EventSourcingHandler<T> {
    private final Class<T> handlerType;
    private final HandlerInvoker<Message> invoker;

    public AnnotatedEventSourcingHandler(Class<T> handlerType) {
        this(handlerType, Arrays.asList(new PayloadParameterResolver(), new MetadataParameterResolver(), new MessageParameterResolver()));
    }

    public AnnotatedEventSourcingHandler(Class<T> handlerType, List<ParameterResolver<? super Message>> parameterResolvers) {
        this.handlerType = handlerType;
        this.invoker = HandlerInspector.inspect(handlerType, ApplyEvent.class, parameterResolvers);
    }

    @Override
    public T apply(Message message, T model) {
        Object result;
        try {
            result = this.invoker.invoke(model, (Object)message);
        }
        catch (HandlerNotFoundException e) {
            if (model == null) {
                throw e;
            }
            return model;
        }
        if (model == null) {
            return this.handlerType.cast(result);
        }
        if (this.handlerType.isInstance(result)) {
            return this.handlerType.cast(result);
        }
        if (result == null && this.invoker.expectResult(model, (Object)message)) {
            return null;
        }
        return model;
    }
}

