/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.keyvalue;

import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.keyvalue.KeyValueStore;
import io.fluxcapacitor.javaclient.keyvalue.KeyValueStoreException;
import io.fluxcapacitor.javaclient.keyvalue.client.KeyValueClient;
import java.beans.ConstructorProperties;

public class DefaultKeyValueStore
implements KeyValueStore {
    private final KeyValueClient client;
    private final Serializer serializer;

    @Override
    public void store(String key, Object value) {
        try {
            this.client.putValue(key, this.serializer.serialize(value)).await();
        }
        catch (Exception e) {
            throw new KeyValueStoreException(String.format("Could not store a value %s for key %s", value, key), e);
        }
    }

    @Override
    public <R> R get(String key) {
        try {
            Data<byte[]> value = this.client.getValue(key);
            return value == null ? null : (R)this.serializer.deserialize(value);
        }
        catch (Exception e) {
            throw new KeyValueStoreException(String.format("Could not get the value for key %s", key), e);
        }
    }

    @Override
    public void delete(String key) {
        try {
            this.client.deleteValue(key).await();
        }
        catch (Exception e) {
            throw new KeyValueStoreException(String.format("Could not delete the value at key %s", key), e);
        }
    }

    @ConstructorProperties(value={"client", "serializer"})
    public DefaultKeyValueStore(KeyValueClient client, Serializer serializer) {
        this.client = client;
        this.serializer = serializer;
    }
}

