/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.keyvalue.client;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.javaclient.keyvalue.client.KeyValueClient;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryKeyValueClient
implements KeyValueClient {
    private final Map<String, Data<byte[]>> values;

    public InMemoryKeyValueClient() {
        this(new ConcurrentHashMap<String, Data<byte[]>>());
    }

    protected InMemoryKeyValueClient(Map<String, Data<byte[]>> map) {
        this.values = map;
    }

    @Override
    public Awaitable putValue(String key, Data<byte[]> value) {
        this.values.put(key, value);
        return Awaitable.ready();
    }

    @Override
    public Data<byte[]> getValue(String key) {
        return this.values.get(key);
    }

    @Override
    public Awaitable deleteValue(String key) {
        this.values.remove(key);
        return Awaitable.ready();
    }

    @Override
    public void close() {
    }
}

