/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.keyvalue.client;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.Backlog;
import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.Request;
import io.fluxcapacitor.common.api.keyvalue.DeleteValue;
import io.fluxcapacitor.common.api.keyvalue.GetValue;
import io.fluxcapacitor.common.api.keyvalue.GetValueResult;
import io.fluxcapacitor.common.api.keyvalue.KeyValuePair;
import io.fluxcapacitor.common.api.keyvalue.StoreValues;
import io.fluxcapacitor.javaclient.common.websocket.AbstractWebsocketClient;
import io.fluxcapacitor.javaclient.common.websocket.JsonDecoder;
import io.fluxcapacitor.javaclient.common.websocket.JsonEncoder;
import io.fluxcapacitor.javaclient.keyvalue.client.KeyValueClient;
import java.net.URI;
import java.util.List;
import javax.websocket.ClientEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint(encoders={JsonEncoder.class}, decoders={JsonDecoder.class})
public class WebsocketKeyValueClient
extends AbstractWebsocketClient
implements KeyValueClient {
    private static final Logger log = LoggerFactory.getLogger(WebsocketKeyValueClient.class);
    private final Backlog<KeyValuePair> backlog = new Backlog(this::storeValues);

    public WebsocketKeyValueClient(String endPointUrl) {
        this(URI.create(endPointUrl));
    }

    public WebsocketKeyValueClient(URI endpointUri) {
        super(endpointUri);
    }

    protected Awaitable storeValues(List<KeyValuePair> keyValuePairs) {
        return this.send(new StoreValues(keyValuePairs));
    }

    @Override
    public Awaitable putValue(String key, Data<byte[]> value) {
        return this.backlog.add((Object[])new KeyValuePair[]{new KeyValuePair(key, value)});
    }

    @Override
    public Data<byte[]> getValue(String key) {
        GetValueResult result = (GetValueResult)this.sendRequest((Request)new GetValue(key));
        return result.getValue();
    }

    @Override
    public Awaitable deleteValue(String key) {
        return this.send(new DeleteValue(key));
    }
}

