/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.MessageSerializer;
import io.fluxcapacitor.javaclient.publishing.ErrorGateway;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultErrorGateway
implements ErrorGateway {
    private static final Logger log = LoggerFactory.getLogger(DefaultErrorGateway.class);
    private final GatewayClient errorGateway;
    private final MessageSerializer serializer;

    @Override
    public void report(Exception payload, Metadata metadata, String target) {
        try {
            SerializedMessage message = this.serializer.serialize(new Message(payload, metadata, MessageType.ERROR));
            message.setTarget(target);
            this.errorGateway.send(message);
        }
        catch (Exception e) {
            log.error("Failed to report error {}", (Object)payload, (Object)e);
        }
    }

    @ConstructorProperties(value={"errorGateway", "serializer"})
    public DefaultErrorGateway(GatewayClient errorGateway, MessageSerializer serializer) {
        this.errorGateway = errorGateway;
        this.serializer = serializer;
    }
}

