/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingObject;
import io.fluxcapacitor.javaclient.common.serialization.MessageSerializer;
import io.fluxcapacitor.javaclient.publishing.EventGateway;
import io.fluxcapacitor.javaclient.publishing.GatewayException;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerFactory;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;

public class DefaultEventGateway
implements EventGateway {
    private final GatewayClient gatewayClient;
    private final MessageSerializer serializer;
    private final HandlerFactory handlerFactory;
    private final List<Handler<DeserializingMessage>> localHandlers = new CopyOnWriteArrayList<Handler<DeserializingMessage>>();

    @Override
    public void publish(Message message) {
        SerializedMessage serializedMessage = this.serializer.serialize(message);
        this.tryHandleLocally(message.getPayload(), serializedMessage);
        try {
            this.gatewayClient.send(serializedMessage);
        }
        catch (Exception e) {
            throw new GatewayException(String.format("Failed to send and forget %s", (Object[])message.getPayload()), e);
        }
    }

    @Override
    public Registration registerLocalHandler(Object target) {
        Optional<Handler<DeserializingMessage>> handler = this.handlerFactory.createHandler(target);
        handler.ifPresent(this.localHandlers::add);
        return () -> handler.ifPresent(this.localHandlers::remove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryHandleLocally(Object payload, SerializedMessage serializedMessage) {
        if (!this.localHandlers.isEmpty()) {
            DeserializingMessage current = DeserializingMessage.getCurrent();
            try {
                DeserializingMessage deserializingMessage = new DeserializingMessage(new DeserializingObject<byte[], SerializedMessage>(serializedMessage, () -> payload), MessageType.EVENT);
                DeserializingMessage.setCurrent(deserializingMessage);
                for (Handler<DeserializingMessage> handler : this.localHandlers) {
                    if (!handler.canHandle((Object)deserializingMessage)) continue;
                    handler.invoke((Object)deserializingMessage);
                }
            }
            finally {
                DeserializingMessage.setCurrent(current);
            }
        }
    }

    @ConstructorProperties(value={"gatewayClient", "serializer", "handlerFactory"})
    public DefaultEventGateway(GatewayClient gatewayClient, MessageSerializer serializer, HandlerFactory handlerFactory) {
        this.gatewayClient = gatewayClient;
        this.serializer = serializer;
        this.handlerFactory = handlerFactory;
    }
}

