/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.publishing.RequestHandler;
import io.fluxcapacitor.javaclient.tracking.client.TrackingClient;
import io.fluxcapacitor.javaclient.tracking.client.TrackingUtils;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestHandler
implements RequestHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultRequestHandler.class);
    private final TrackingClient trackingClient;
    private final Serializer serializer;
    private final String clientName;
    private final String clientId;
    private final Map<Integer, CompletableFuture<Message>> callbacks = new ConcurrentHashMap<Integer, CompletableFuture<Message>>();
    private final AtomicInteger nextId = new AtomicInteger();
    private final AtomicBoolean started = new AtomicBoolean();

    @Override
    public CompletableFuture<Message> sendRequest(SerializedMessage request, Consumer<SerializedMessage> requestSender) {
        if (this.started.compareAndSet(false, true)) {
            TrackingUtils.start(String.format("%s_RESULT", this.clientName), this.trackingClient, this::handleMessages);
        }
        CompletableFuture<Message> result = new CompletableFuture<Message>();
        int requestId = this.nextId.getAndIncrement();
        this.callbacks.put(requestId, result);
        request.setRequestId(Integer.valueOf(requestId));
        request.setSource(this.clientId);
        requestSender.accept(request);
        return result;
    }

    protected void handleMessages(List<SerializedMessage> messages) {
        messages.forEach(m -> {
            Object result;
            CompletableFuture<Message> future = this.callbacks.remove(m.getRequestId());
            if (future == null) {
                log.warn("Received response with index {} for unknown request {}", (Object)m.getIndex(), (Object)m.getRequestId());
                return;
            }
            try {
                result = this.serializer.deserialize((Data<byte[]>)m.getData());
            }
            catch (Exception e) {
                log.error("Failed to deserialize result with id {}. Continuing with next result", (Object)m.getRequestId(), (Object)e);
                future.completeExceptionally(e);
                return;
            }
            try {
                if (result instanceof Throwable) {
                    future.completeExceptionally((Exception)result);
                } else {
                    future.complete(new Message(result, m.getMetadata(), MessageType.RESULT));
                }
            }
            catch (Exception e) {
                log.error("Failed to complete request with id {}", (Object)m.getRequestId(), (Object)e);
            }
        });
    }

    @ConstructorProperties(value={"trackingClient", "serializer", "clientName", "clientId"})
    public DefaultRequestHandler(TrackingClient trackingClient, Serializer serializer, String clientName, String clientId) {
        this.trackingClient = trackingClient;
        this.serializer = serializer;
        this.clientName = clientName;
        this.clientId = clientId;
    }
}

