/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing.correlation;

import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.publishing.correlation.CorrelationDataProvider;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;

public class CorrelatingInterceptor
implements DispatchInterceptor {
    private final Collection<? extends CorrelationDataProvider> correlationDataProviders;

    @Override
    public Function<Message, SerializedMessage> interceptDispatch(Function<Message, SerializedMessage> function) {
        return message -> {
            Optional.ofNullable(DeserializingMessage.getCurrent()).ifPresent(currentMessage -> this.correlationDataProviders.forEach(p -> message.getMetadata().putAll(p.fromMessage((DeserializingMessage)currentMessage))));
            return (SerializedMessage)function.apply((Message)message);
        };
    }

    @ConstructorProperties(value={"correlationDataProviders"})
    public CorrelatingInterceptor(Collection<? extends CorrelationDataProvider> correlationDataProviders) {
        this.correlationDataProviders = correlationDataProviders;
    }
}

