/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing.correlation;

import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.publishing.correlation.CorrelationDataProvider;
import io.fluxcapacitor.javaclient.publishing.routing.RoutingKey;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;

public class MessageOriginProvider
implements CorrelationDataProvider {
    private final Client client;
    private final String clientId;
    private final String correlationId;
    private final String traceId;
    private final String trigger;
    private final String triggerRoutingKey;

    public MessageOriginProvider(Client client) {
        this(client, "$clientId", "$correlationId", "$traceId", "$trigger", "$triggerRoutingKey");
    }

    @Override
    public Map<String, String> fromMessage(DeserializingMessage message) {
        HashMap<String, String> result = new HashMap<String, String>();
        Long index = message.getSerializedObject().getIndex();
        if (index != null) {
            String correlationId = index.toString();
            result.put(this.correlationId, correlationId);
            result.put(this.traceId, message.getMetadata().getOrDefault((Object)this.traceId, correlationId));
        }
        result.put(this.clientId, this.client.id());
        result.put(this.trigger, message.getSerializedObject().getData().getType());
        if (message.isDeserialized()) {
            ReflectionUtils.getAnnotatedPropertyValue((Object)message.getPayload(), RoutingKey.class).map(Object::toString).ifPresent(v -> result.put(this.triggerRoutingKey, (String)v));
        }
        return result;
    }

    @ConstructorProperties(value={"client", "clientId", "correlationId", "traceId", "trigger", "triggerRoutingKey"})
    public MessageOriginProvider(Client client, String clientId, String correlationId, String traceId, String trigger, String triggerRoutingKey) {
        this.client = client;
        this.clientId = clientId;
        this.correlationId = correlationId;
        this.traceId = traceId;
        this.trigger = trigger;
        this.triggerRoutingKey = triggerRoutingKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageOriginProvider)) {
            return false;
        }
        MessageOriginProvider other = (MessageOriginProvider)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Client this$client = this.client;
        Client other$client = other.client;
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        String this$clientId = this.clientId;
        String other$clientId = other.clientId;
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$correlationId = this.correlationId;
        String other$correlationId = other.correlationId;
        if (this$correlationId == null ? other$correlationId != null : !this$correlationId.equals(other$correlationId)) {
            return false;
        }
        String this$traceId = this.traceId;
        String other$traceId = other.traceId;
        if (this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId)) {
            return false;
        }
        String this$trigger = this.trigger;
        String other$trigger = other.trigger;
        if (this$trigger == null ? other$trigger != null : !this$trigger.equals(other$trigger)) {
            return false;
        }
        String this$triggerRoutingKey = this.triggerRoutingKey;
        String other$triggerRoutingKey = other.triggerRoutingKey;
        return !(this$triggerRoutingKey == null ? other$triggerRoutingKey != null : !this$triggerRoutingKey.equals(other$triggerRoutingKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageOriginProvider;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Client $client = this.client;
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        String $clientId = this.clientId;
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $correlationId = this.correlationId;
        result = result * 59 + ($correlationId == null ? 43 : $correlationId.hashCode());
        String $traceId = this.traceId;
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        String $trigger = this.trigger;
        result = result * 59 + ($trigger == null ? 43 : $trigger.hashCode());
        String $triggerRoutingKey = this.triggerRoutingKey;
        result = result * 59 + ($triggerRoutingKey == null ? 43 : $triggerRoutingKey.hashCode());
        return result;
    }
}

