/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing.dataprotection;

import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.keyvalue.KeyValueStore;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.publishing.dataprotection.DropProtectedData;
import io.fluxcapacitor.javaclient.publishing.dataprotection.ProtectData;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import java.beans.ConstructorProperties;
import java.lang.reflect.AccessibleObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;

public class DataProtectionInterceptor
implements DispatchInterceptor,
HandlerInterceptor {
    public static String METADATA_KEY = "$protectedData";
    private final KeyValueStore keyValueStore;
    private final Serializer serializer;

    @Override
    public Function<Message, SerializedMessage> interceptDispatch(Function<Message, SerializedMessage> function) {
        return m -> {
            HashMap<String, String> protectedFields = new HashMap<String, String>();
            if (m.getMetadata().containsKey((Object)METADATA_KEY)) {
                protectedFields.putAll((Map)m.getMetadata().get(METADATA_KEY, Map.class));
            } else {
                Object payload = m.getPayload();
                ReflectionUtils.getAnnotatedFields(m.getPayload(), ProtectData.class).forEach(field -> {
                    Object value = ReflectionUtils.getProperty((AccessibleObject)field, (Object)payload);
                    String key = UUID.randomUUID().toString();
                    this.keyValueStore.store(key, value);
                    protectedFields.put(field.getName(), key);
                });
                if (!protectedFields.isEmpty()) {
                    m.getMetadata().put(METADATA_KEY, protectedFields);
                }
            }
            if (!protectedFields.isEmpty()) {
                Object payloadCopy = this.serializer.deserialize(this.serializer.serialize(m.getPayload()));
                protectedFields.forEach((name, key) -> ReflectionUtils.setField((String)name, (Object)payloadCopy, null));
                m = m.withPayload(payloadCopy);
            }
            return (SerializedMessage)function.apply((Message)m);
        };
    }

    @Override
    public Function<DeserializingMessage, Object> interceptHandling(Function<DeserializingMessage, Object> function, Handler<DeserializingMessage> handler, String consumer) {
        return m -> {
            if (m.getMetadata().containsKey((Object)METADATA_KEY)) {
                Object payload = m.getPayload();
                Map protectedFields = (Map)m.getMetadata().get(METADATA_KEY, Map.class);
                boolean dropProtectedData = handler.getMethod(m).isAnnotationPresent(DropProtectedData.class);
                protectedFields.forEach((fieldName, key) -> {
                    ReflectionUtils.setField((String)fieldName, (Object)payload, this.keyValueStore.get((String)key));
                    if (dropProtectedData) {
                        this.keyValueStore.delete((String)key);
                    }
                });
            }
            return function.apply((DeserializingMessage)m);
        };
    }

    @ConstructorProperties(value={"keyValueStore", "serializer"})
    public DataProtectionInterceptor(KeyValueStore keyValueStore, Serializer serializer) {
        this.keyValueStore = keyValueStore;
        this.serializer = serializer;
    }
}

