/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.scheduling.client;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.Backlog;
import io.fluxcapacitor.common.api.scheduling.CancelSchedule;
import io.fluxcapacitor.common.api.scheduling.Schedule;
import io.fluxcapacitor.common.api.scheduling.ScheduledMessage;
import io.fluxcapacitor.javaclient.common.websocket.AbstractWebsocketClient;
import io.fluxcapacitor.javaclient.common.websocket.JsonDecoder;
import io.fluxcapacitor.javaclient.common.websocket.JsonEncoder;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import java.net.URI;
import java.util.List;
import javax.websocket.ClientEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint(encoders={JsonEncoder.class}, decoders={JsonDecoder.class})
public class WebsocketSchedulingClient
extends AbstractWebsocketClient
implements SchedulingClient {
    private static final Logger log = LoggerFactory.getLogger(WebsocketSchedulingClient.class);
    private final Backlog<ScheduledMessage> backlog = new Backlog(this::scheduleMessages);

    public WebsocketSchedulingClient(String endPointUrl) {
        this(URI.create(endPointUrl));
    }

    public WebsocketSchedulingClient(URI endpointUri) {
        super(endpointUri);
    }

    protected Awaitable scheduleMessages(List<ScheduledMessage> scheduledMessages) {
        return this.send(new Schedule(scheduledMessages));
    }

    @Override
    public Awaitable schedule(ScheduledMessage ... schedules) {
        return this.backlog.add((Object[])schedules);
    }

    @Override
    public Awaitable cancelSchedule(String scheduleId) {
        return this.send(new CancelSchedule(scheduleId));
    }
}

