/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerInspector;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.exception.FunctionalException;
import io.fluxcapacitor.javaclient.common.exception.TechnicalException;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingObject;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.eventsourcing.CacheInvalidatingInterceptor;
import io.fluxcapacitor.javaclient.publishing.ResultGateway;
import io.fluxcapacitor.javaclient.tracking.BatchInterceptor;
import io.fluxcapacitor.javaclient.tracking.ConsumerConfiguration;
import io.fluxcapacitor.javaclient.tracking.FluxCapacitorInterceptor;
import io.fluxcapacitor.javaclient.tracking.Tracking;
import io.fluxcapacitor.javaclient.tracking.TrackingConfiguration;
import io.fluxcapacitor.javaclient.tracking.TrackingException;
import io.fluxcapacitor.javaclient.tracking.client.TrackingClient;
import io.fluxcapacitor.javaclient.tracking.client.TrackingUtils;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTracking
implements Tracking {
    private static final Logger log = LoggerFactory.getLogger(DefaultTracking.class);
    private final MessageType messageType;
    private final Class<? extends Annotation> handlerAnnotation;
    private final TrackingClient trackingClient;
    private final ResultGateway resultGateway;
    private final List<ConsumerConfiguration> configurations;
    private final Serializer serializer;
    private final HandlerInterceptor handlerInterceptor;
    private final List<ParameterResolver<? super DeserializingMessage>> parameterResolvers;
    private final Set<ConsumerConfiguration> startedConfigurations = new HashSet<ConsumerConfiguration>();
    private final AtomicReference<Registration> shutdownFunction = new AtomicReference<Registration>(Registration.noOp());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Registration start(FluxCapacitor fluxCapacitor, List<?> handlers) {
        DefaultTracking defaultTracking = this;
        synchronized (defaultTracking) {
            Map<ConsumerConfiguration, List<Object>> consumers = handlers.stream().filter(h -> HandlerInspector.hasHandlerMethods(h.getClass(), this.handlerAnnotation)).collect(Collectors.groupingBy(h -> this.configurations.stream().filter(config -> config.getHandlerFilter().test(h)).findFirst().orElseThrow(() -> new TrackingException(String.format("Failed to find consumer for %s", h)))));
            if (!Collections.disjoint(consumers.keySet(), this.startedConfigurations)) {
                throw new TrackingException("Failed to start tracking. Consumers for some handlers have already started tracking.");
            }
            this.startedConfigurations.addAll(consumers.keySet());
            Registration registration = consumers.entrySet().stream().map(e -> this.startTracking((ConsumerConfiguration)e.getKey(), (List)e.getValue(), fluxCapacitor)).reduce(Registration::merge).orElse(Registration.noOp());
            this.shutdownFunction.updateAndGet(arg_0 -> ((Registration)registration).merge(arg_0));
            return registration;
        }
    }

    protected Registration startTracking(ConsumerConfiguration configuration, List<Object> handlers, FluxCapacitor fluxCapacitor) {
        Consumer<List<SerializedMessage>> consumer = this.createConsumer(configuration, handlers);
        ArrayList<BatchInterceptor> batchInterceptors = new ArrayList<BatchInterceptor>(Arrays.asList(new FluxCapacitorInterceptor(fluxCapacitor), new CacheInvalidatingInterceptor(fluxCapacitor.eventSourcing())));
        batchInterceptors.addAll(configuration.getTrackingConfiguration().getBatchInterceptors());
        TrackingConfiguration config = configuration.getTrackingConfiguration().toBuilder().clearBatchInterceptors().batchInterceptors(batchInterceptors).build();
        String trackerName = configuration.prependApplicationName() ? String.format("%s_%s", fluxCapacitor.client().name(), configuration.getName()) : configuration.getName();
        return TrackingUtils.start(trackerName, consumer, this.trackingClient, config);
    }

    protected Consumer<List<SerializedMessage>> createConsumer(ConsumerConfiguration configuration, List<Object> targets) {
        List handlers = HandlerInspector.createHandlers(targets, this.handlerAnnotation, this.parameterResolvers);
        return serializedMessages -> {
            Stream<DeserializingMessage> messages = this.serializer.deserialize(serializedMessages.stream(), false).map(m -> new DeserializingMessage((DeserializingObject<byte[], SerializedMessage>)m, this.messageType));
            messages.forEach(m -> {
                try {
                    DeserializingMessage.setCurrent(m);
                    handlers.forEach(h -> this.tryHandle((DeserializingMessage)m, (Handler<DeserializingMessage>)h, configuration));
                }
                finally {
                    DeserializingMessage.removeCurrent();
                }
            });
        };
    }

    protected void tryHandle(DeserializingMessage message, Handler<DeserializingMessage> handler, ConsumerConfiguration config) {
        try {
            if (handler.canHandle((Object)message)) {
                this.handle(message, handler, config);
            }
        }
        catch (Exception e) {
            config.getErrorHandler().handleError(e, String.format("Handler %s failed to handle a %s", handler, message), () -> this.handle(message, handler, config));
        }
    }

    protected void handle(DeserializingMessage message, Handler<DeserializingMessage> handler, ConsumerConfiguration config) {
        Object result;
        Exception exception = null;
        try {
            result = this.handlerInterceptor.interceptHandling(m -> handler.invoke((Object)message), handler, config.getName()).apply(message);
        }
        catch (FunctionalException e) {
            result = e;
            exception = e;
        }
        catch (Exception e) {
            result = new TechnicalException(String.format("Handler %s failed to handle a %s", handler, message));
            exception = e;
        }
        SerializedMessage serializedMessage = message.getSerializedObject();
        if (serializedMessage.getRequestId() != null) {
            this.resultGateway.respond(result, serializedMessage.getSource(), serializedMessage.getRequestId());
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public void close() {
        this.shutdownFunction.get().cancel();
    }

    @ConstructorProperties(value={"messageType", "handlerAnnotation", "trackingClient", "resultGateway", "configurations", "serializer", "handlerInterceptor", "parameterResolvers"})
    public DefaultTracking(MessageType messageType, Class<? extends Annotation> handlerAnnotation, TrackingClient trackingClient, ResultGateway resultGateway, List<ConsumerConfiguration> configurations, Serializer serializer, HandlerInterceptor handlerInterceptor, List<ParameterResolver<? super DeserializingMessage>> parameterResolvers) {
        this.messageType = messageType;
        this.handlerAnnotation = handlerAnnotation;
        this.trackingClient = trackingClient;
        this.resultGateway = resultGateway;
        this.configurations = configurations;
        this.serializer = serializer;
        this.handlerInterceptor = handlerInterceptor;
        this.parameterResolvers = parameterResolvers;
    }
}

