/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking;

import io.fluxcapacitor.common.TimingUtils;
import io.fluxcapacitor.javaclient.tracking.ErrorHandler;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryingErrorHandler
implements ErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(RetryingErrorHandler.class);
    private final int retries;
    private final Duration delay;
    private final Predicate<Exception> errorFilter;
    private final boolean throwOnFailure;

    public static RetryingErrorHandler forAnyError() {
        return new RetryingErrorHandler(e -> true);
    }

    public RetryingErrorHandler(Predicate<Exception> errorFilter) {
        this(5, Duration.ofSeconds(2L), errorFilter, false);
    }

    @Override
    public void handleError(Exception error, String errorMessage, Runnable retryFunction) throws Exception {
        if (!this.errorFilter.test(error)) {
            log.error("{}. Not retrying, {}", new Object[]{errorMessage, this.throwOnFailure ? "propagating error" : "continuing.", error});
            if (this.throwOnFailure) {
                throw error;
            }
            return;
        }
        log.error("{}. Retrying up to {} times.", (Object)errorMessage, (Object)this.retries);
        AtomicInteger remainingRetries = new AtomicInteger(this.retries);
        boolean success = TimingUtils.retryOnFailure((Runnable)retryFunction, (Duration)this.delay, e -> this.errorFilter.test((Exception)e) && remainingRetries.decrementAndGet() > 0);
        if (!success && this.throwOnFailure) {
            log.error("Propagating error");
            throw error;
        }
    }

    @ConstructorProperties(value={"retries", "delay", "errorFilter", "throwOnFailure"})
    public RetryingErrorHandler(int retries, Duration delay, Predicate<Exception> errorFilter, boolean throwOnFailure) {
        this.retries = retries;
        this.delay = delay;
        this.errorFilter = errorFilter;
        this.throwOnFailure = throwOnFailure;
    }
}

