/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.client;

import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.TimingUtils;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.tracking.MessageBatch;
import io.fluxcapacitor.javaclient.tracking.BatchInterceptor;
import io.fluxcapacitor.javaclient.tracking.Tracker;
import io.fluxcapacitor.javaclient.tracking.TrackingConfiguration;
import io.fluxcapacitor.javaclient.tracking.client.TrackingClient;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTracker
implements Runnable,
Registration {
    private static final Logger log = LoggerFactory.getLogger(DefaultTracker.class);
    private final String name;
    private final int channel;
    private final TrackingConfiguration configuration;
    private final Consumer<MessageBatch> processor;
    private final Consumer<List<SerializedMessage>> consumer;
    private final TrackingClient trackingClient;
    private final AtomicBoolean running = new AtomicBoolean();
    private final AtomicReference<Thread> thread = new AtomicReference();
    private volatile boolean processing;

    public DefaultTracker(String name, int channel, TrackingConfiguration configuration, Consumer<List<SerializedMessage>> consumer, TrackingClient trackingClient) {
        this.name = name;
        this.channel = channel;
        this.configuration = configuration;
        this.processor = BatchInterceptor.join(configuration.getBatchInterceptors()).intercept(this::processAll, new Tracker(name, channel));
        this.consumer = consumer;
        this.trackingClient = trackingClient;
    }

    @Override
    public void run() {
        if (this.running.compareAndSet(false, true)) {
            this.thread.set(Thread.currentThread());
            MessageBatch batch = this.fetch();
            while (this.running.get()) {
                this.processor.accept(batch);
                batch = this.fetch();
            }
        }
    }

    public void cancel() {
        block10: {
            if (!this.running.compareAndSet(true, false)) break block10;
            if (this.processing) {
                while (this.processing) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            } else {
                try {
                    this.thread.get().interrupt();
                }
                catch (Exception e) {
                    log.warn("Not allowed to cancel tracker {}", (Object)this.name, (Object)e);
                }
                finally {
                    this.thread.set(null);
                }
            }
        }
    }

    protected MessageBatch fetch() {
        return (MessageBatch)TimingUtils.retryOnFailure(() -> this.trackingClient.read(this.name, this.channel, this.configuration.getMaxFetchBatchSize(), this.configuration.getMaxWaitDuration(), this.configuration.getTypeFilter(), this.configuration.ignoreMessageTarget(), this.configuration.getReadStrategy()), (Duration)this.configuration.getRetryDelay(), e -> this.running.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAll(MessageBatch messageBatch) {
        try {
            this.processing = true;
            List messages = messageBatch.getMessages();
            if (messages.isEmpty() || !this.running.get()) {
                return;
            }
            if (messages.size() > this.configuration.getMaxConsumerBatchSize()) {
                for (int i = 0; i < messages.size(); i += this.configuration.getMaxConsumerBatchSize()) {
                    List<SerializedMessage> batch = messages.subList(i, Math.min(i + this.configuration.getMaxConsumerBatchSize(), messages.size()));
                    this.processPart(batch, messageBatch.getSegment());
                }
            } else {
                this.processPart(messages, messageBatch.getSegment());
            }
        }
        finally {
            this.processing = false;
        }
    }

    protected void processPart(List<SerializedMessage> batch, int[] segment) {
        try {
            this.consumer.accept(batch);
        }
        catch (Exception e2) {
            log.error("Consumer {} failed to handle batch of {} messages and did not handle exception. Tracker will be stopped.", new Object[]{this.name, batch.size(), e2});
            this.cancel();
            throw e2;
        }
        TimingUtils.retryOnFailure(() -> this.updatePosition(segment, ((SerializedMessage)batch.get(batch.size() - 1)).getIndex()), (Duration)this.configuration.getRetryDelay(), e -> this.running.get());
    }

    private void updatePosition(int[] segment, Long lastIndex) {
        this.trackingClient.storePosition(this.name, segment, lastIndex).await();
    }
}

