/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.client;

import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.javaclient.tracking.TrackingConfiguration;
import io.fluxcapacitor.javaclient.tracking.client.DefaultTracker;
import io.fluxcapacitor.javaclient.tracking.client.TrackingClient;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class TrackingUtils {
    public static Registration start(String name, TrackingClient trackingClient, Consumer<List<SerializedMessage>> consumer) {
        return TrackingUtils.start(name, consumer, trackingClient, TrackingConfiguration.DEFAULT);
    }

    public static Registration start(String name, int threads, TrackingClient trackingClient, Consumer<List<SerializedMessage>> consumer) {
        return TrackingUtils.start(name, consumer, trackingClient, TrackingConfiguration.builder().threads(threads).build());
    }

    public static Registration start(String consumerName, Consumer<List<SerializedMessage>> consumer, TrackingClient trackingClient, TrackingConfiguration configuration) {
        List<DefaultTracker> instances = IntStream.range(0, configuration.getThreads()).mapToObj(i -> new DefaultTracker(consumerName, i, configuration, consumer, trackingClient)).collect(Collectors.toList());
        ExecutorService executor = Executors.newFixedThreadPool(configuration.getThreads());
        instances.forEach(executor::submit);
        return () -> {
            instances.forEach(DefaultTracker::cancel);
            executor.shutdownNow();
        };
    }
}

