/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.client;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.api.Request;
import io.fluxcapacitor.common.api.tracking.MessageBatch;
import io.fluxcapacitor.common.api.tracking.Read;
import io.fluxcapacitor.common.api.tracking.ReadResult;
import io.fluxcapacitor.common.api.tracking.StorePosition;
import io.fluxcapacitor.common.api.tracking.TrackingStrategy;
import io.fluxcapacitor.javaclient.common.websocket.AbstractWebsocketClient;
import io.fluxcapacitor.javaclient.common.websocket.JsonDecoder;
import io.fluxcapacitor.javaclient.common.websocket.JsonEncoder;
import io.fluxcapacitor.javaclient.tracking.client.TrackingClient;
import java.net.URI;
import java.time.Duration;
import javax.websocket.ClientEndpoint;

@ClientEndpoint(encoders={JsonEncoder.class}, decoders={JsonDecoder.class})
public class WebsocketTrackingClient
extends AbstractWebsocketClient
implements TrackingClient {
    public WebsocketTrackingClient(String endPointUrl) {
        this(URI.create(endPointUrl));
    }

    public WebsocketTrackingClient(URI endPointUri) {
        super(endPointUri);
    }

    @Override
    public MessageBatch read(String consumer, int channel, int maxSize, Duration maxTimeout, String typeFilter, boolean ignoreMessageTarget, TrackingStrategy strategy) {
        ReadResult readResult = (ReadResult)this.sendRequest((Request)new Read(consumer, channel, maxSize, maxTimeout.toMillis(), typeFilter, ignoreMessageTarget, strategy));
        return readResult.getMessageBatch();
    }

    @Override
    public Awaitable storePosition(String consumer, int[] segment, long lastIndex) {
        return this.send(new StorePosition(consumer, segment, lastIndex));
    }
}

