/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling.validation;

import io.fluxcapacitor.javaclient.common.exception.FunctionalException;
import java.beans.ConstructorProperties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;

public class ValidationException
extends FunctionalException {
    private final SortedSet<String> violations;

    public ValidationException(Set<? extends ConstraintViolation<?>> violations) {
        super(String.format("One or more constraints were violated:%s%s", System.lineSeparator(), ValidationException.format(violations)));
        this.violations = violations.stream().map(ValidationException::format).collect(Collectors.toCollection(TreeSet::new));
    }

    @ConstructorProperties(value={"message", "violations"})
    public ValidationException(String message, Set<String> violations) {
        super(message);
        this.violations = new TreeSet<String>(violations);
    }

    protected static String format(ConstraintViolation<?> v) {
        return String.format("property %s in class %s %s", v.getPropertyPath(), v.getRootBeanClass().getSimpleName(), v.getMessage());
    }

    protected static String format(Set<? extends ConstraintViolation<?>> violations) {
        return violations.stream().map(ValidationException::format).sorted().collect(Collectors.joining(System.lineSeparator()));
    }

    public SortedSet<String> getViolations() {
        return this.violations;
    }
}

