/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.benchmark;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerInspector;
import io.fluxcapacitor.javaclient.benchmark.AbstractClientBenchmark;
import io.fluxcapacitor.javaclient.common.websocket.ServiceUrlBuilder;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.publishing.client.WebsocketGatewayClient;
import io.fluxcapacitor.javaclient.tracking.client.TrackingClient;
import io.fluxcapacitor.javaclient.tracking.client.TrackingUtils;
import io.fluxcapacitor.javaclient.tracking.client.WebsocketTrackingClient;
import io.fluxcapacitor.javaclient.tracking.handling.HandleCommand;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowLevelJavaClientRunner
extends AbstractClientBenchmark {
    private static final Logger log = LoggerFactory.getLogger(LowLevelJavaClientRunner.class);
    private final GatewayClient gatewayClient = new WebsocketGatewayClient(ServiceUrlBuilder.producerUrl((MessageType)MessageType.COMMAND, (WebSocketClient.Properties)this.getClientProperties()));
    private final Handler<SerializedMessage> commandInvoker;

    public static void main(String[] args) {
        LowLevelJavaClientRunner runner = new LowLevelJavaClientRunner(100000);
        runner.testCommands();
        System.exit(0);
    }

    public LowLevelJavaClientRunner(int commandCount) {
        super(commandCount);
        TrackingUtils.start((String)"javaClientRunner/command", (TrackingClient)new WebsocketTrackingClient(ServiceUrlBuilder.consumerUrl((MessageType)MessageType.COMMAND, (WebSocketClient.Properties)this.getClientProperties())), this::handleCommands);
        this.commandInvoker = HandlerInspector.createHandler((Object)this, HandleCommand.class, Collections.singletonList(p -> m -> m));
        CountDownLatch commandsSentCountdown = new CountDownLatch(commandCount);
        this.gatewayClient.registerMonitor(m -> {
            commandsSentCountdown.countDown();
            if (commandsSentCountdown.getCount() == 0L) {
                log.info("Finished sending {} commands", (Object)commandCount);
            }
        });
    }

    @Override
    protected void doSendCommand(String payload) {
        this.gatewayClient.send(new SerializedMessage[]{new SerializedMessage(new Data((Object)payload.getBytes(), String.class.getName(), 0), Metadata.empty(), UUID.randomUUID().toString())});
    }

    @HandleCommand
    public void handleCommand(SerializedMessage command) {
        this.getCommandCountDownLatch().countDown();
    }

    private void handleCommands(List<SerializedMessage> commands) {
        commands.forEach(m -> {
            try {
                this.commandInvoker.invoke(m);
            }
            catch (Exception e) {
                log.error("Failed to handle command", (Throwable)e);
                throw new IllegalStateException("Failed to handle command", e);
            }
        });
    }
}

