/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.test;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.configuration.FluxCapacitorBuilder;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.configuration.client.InMemoryClient;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.test.Given;
import io.fluxcapacitor.javaclient.test.Then;
import io.fluxcapacitor.javaclient.test.When;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;

public abstract class AbstractTestFixture
implements Given,
When {
    private final FluxCapacitor fluxCapacitor;
    private final Registration registration;
    private final GivenWhenThenInterceptor interceptor = new GivenWhenThenInterceptor();

    protected AbstractTestFixture(FluxCapacitorBuilder fluxCapacitorBuilder, Function<FluxCapacitor, List<?>> handlerFactory) {
        this.fluxCapacitor = fluxCapacitorBuilder.disableShutdownHook().addDispatchInterceptor((DispatchInterceptor)this.interceptor, new MessageType[0]).build((Client)InMemoryClient.newInstance());
        this.registration = this.registerHandlers(handlerFactory.apply(this.fluxCapacitor));
    }

    public abstract Registration registerHandlers(List<?> var1);

    public abstract void deregisterHandlers(Registration var1);

    protected abstract Then createResultValidator(Object var1);

    protected abstract void registerCommand(Message var1);

    protected abstract void registerEvent(Message var1);

    protected abstract Object getDispatchResult(CompletableFuture<?> var1);

    @Override
    public When givenCommands(Object ... commands) {
        try {
            FluxCapacitor.instance.set(this.fluxCapacitor);
            this.getDispatchResult(CompletableFuture.allOf((CompletableFuture[])this.flatten(commands).map(c -> this.fluxCapacitor.commandGateway().send(c)).toArray(CompletableFuture[]::new)));
            AbstractTestFixture abstractTestFixture = this;
            return abstractTestFixture;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to execute givenCommands", e);
        }
        finally {
            FluxCapacitor.instance.remove();
        }
    }

    @Override
    public When givenEvents(Object ... events) {
        try {
            FluxCapacitor.instance.set(this.fluxCapacitor);
            this.flatten(events).forEach(c -> this.fluxCapacitor.eventGateway().publish(c));
            AbstractTestFixture abstractTestFixture = this;
            return abstractTestFixture;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to execute givenEvents", e);
        }
        finally {
            FluxCapacitor.instance.remove();
        }
    }

    @Override
    public When given(Runnable condition) {
        try {
            FluxCapacitor.instance.set(this.fluxCapacitor);
            condition.run();
            AbstractTestFixture abstractTestFixture = this;
            return abstractTestFixture;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to execute given condition", e);
        }
        finally {
            FluxCapacitor.instance.remove();
        }
    }

    @Override
    public When andGivenCommands(Object ... commands) {
        return this.givenCommands(commands);
    }

    @Override
    public When andGivenEvents(Object ... events) {
        return this.givenEvents(events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Then whenCommand(Object command) {
        try {
            Object result;
            FluxCapacitor.instance.set(this.fluxCapacitor);
            try {
                result = this.getDispatchResult(this.fluxCapacitor.commandGateway().send((Object)this.interceptor.trace(command, MessageType.COMMAND)));
            }
            catch (Exception e) {
                result = e;
            }
            Then then = this.createResultValidator(result);
            return then;
        }
        finally {
            this.deregisterHandlers(this.registration);
            FluxCapacitor.instance.remove();
        }
    }

    @Override
    public Then whenEvent(Object event) {
        try {
            FluxCapacitor.instance.set(this.fluxCapacitor);
            this.fluxCapacitor.eventGateway().publish(this.interceptor.trace(event, MessageType.EVENT));
            Then then = this.createResultValidator(null);
            return then;
        }
        finally {
            this.deregisterHandlers(this.registration);
            FluxCapacitor.instance.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Then whenQuery(Object query) {
        try {
            Object result;
            FluxCapacitor.instance.set(this.fluxCapacitor);
            try {
                result = this.getDispatchResult(this.fluxCapacitor.queryGateway().send((Object)this.interceptor.trace(query, MessageType.QUERY)));
            }
            catch (Exception e) {
                result = e;
            }
            Then then = this.createResultValidator(result);
            return then;
        }
        finally {
            this.deregisterHandlers(this.registration);
            FluxCapacitor.instance.remove();
        }
    }

    @Override
    public Then when(Runnable task) {
        try {
            FluxCapacitor.instance.set(this.fluxCapacitor);
            this.interceptor.catchAll();
            task.run();
            Then then = this.createResultValidator(null);
            return then;
        }
        finally {
            this.deregisterHandlers(this.registration);
            FluxCapacitor.instance.remove();
        }
    }

    public FluxCapacitor getFluxCapacitor() {
        return this.fluxCapacitor;
    }

    protected Stream<Object> flatten(Object ... messages) {
        return Arrays.stream(messages).flatMap(c -> {
            if (c instanceof Collection) {
                return ((Collection)c).stream();
            }
            if (c.getClass().isArray()) {
                return Arrays.stream((Object[])c);
            }
            return Stream.of(c);
        });
    }

    protected class GivenWhenThenInterceptor
    implements DispatchInterceptor {
        private static final String TAG = "givenWhenThen.tag";
        private static final String TAG_NAME = "givenWhenThen.tagName";
        private static final String TRACE_NAME = "givenWhenThen.trace";
        private volatile boolean catchAll;

        protected GivenWhenThenInterceptor() {
        }

        protected void catchAll() {
            this.catchAll = true;
        }

        protected Message trace(Object message, MessageType type) {
            this.catchAll = false;
            Message result = message instanceof Message ? (Message)message : new Message(message, Metadata.empty(), type);
            result.getMetadata().put(TAG_NAME, TAG);
            return result;
        }

        protected boolean isChildMetadata(Metadata messageMetadata) {
            return TAG.equals(messageMetadata.get((Object)TRACE_NAME));
        }

        protected boolean isDescendantMetadata(Metadata messageMetadata) {
            return TAG.equals(this.getTrace(messageMetadata).get(0));
        }

        protected List<String> getTrace(Metadata messageMetadata) {
            return Arrays.asList(messageMetadata.getOrDefault((Object)TRACE_NAME, "").split(","));
        }

        public Function<Message, SerializedMessage> interceptDispatch(Function<Message, SerializedMessage> function) {
            return message -> {
                String tag = UUID.randomUUID().toString();
                message.getMetadata().putIfAbsent(TAG_NAME, tag);
                Optional.ofNullable(DeserializingMessage.getCurrent()).ifPresent(currentMessage -> {
                    if (currentMessage.getMetadata().containsKey((Object)TRACE_NAME)) {
                        message.getMetadata().put(TRACE_NAME, currentMessage.getMetadata().get((Object)TRACE_NAME) + "," + currentMessage.getMetadata().get((Object)TAG_NAME));
                    } else {
                        message.getMetadata().put(TRACE_NAME, currentMessage.getMetadata().get((Object)TAG_NAME));
                    }
                });
                if (this.isDescendantMetadata(message.getMetadata()) || this.catchAll) {
                    switch (message.getMessageType()) {
                        case COMMAND: {
                            AbstractTestFixture.this.registerCommand((Message)message);
                            break;
                        }
                        case EVENT: {
                            AbstractTestFixture.this.registerEvent((Message)message);
                        }
                    }
                }
                return (SerializedMessage)function.apply((Message)message);
            };
        }
    }
}

