/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.test;

import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.configuration.DefaultFluxCapacitor;
import io.fluxcapacitor.javaclient.configuration.FluxCapacitorBuilder;
import io.fluxcapacitor.javaclient.test.AbstractTestFixture;
import io.fluxcapacitor.javaclient.test.ResultValidator;
import io.fluxcapacitor.javaclient.test.Then;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class TestFixture
extends AbstractTestFixture {
    private final List<Message> events = new ArrayList<Message>();
    private final List<Message> commands = new ArrayList<Message>();

    public static TestFixture create(Object ... handlers) {
        return new TestFixture((FluxCapacitorBuilder)DefaultFluxCapacitor.builder(), fc -> Arrays.asList(handlers));
    }

    public static TestFixture create(FluxCapacitorBuilder fluxCapacitorBuilder, Object ... handlers) {
        return new TestFixture(fluxCapacitorBuilder, fc -> Arrays.asList(handlers));
    }

    public static TestFixture create(Function<FluxCapacitor, List<?>> handlersFactory) {
        return new TestFixture((FluxCapacitorBuilder)DefaultFluxCapacitor.builder(), handlersFactory);
    }

    public static TestFixture create(FluxCapacitorBuilder fluxCapacitorBuilder, Function<FluxCapacitor, List<?>> handlersFactory) {
        return new TestFixture(fluxCapacitorBuilder, handlersFactory);
    }

    protected TestFixture(FluxCapacitorBuilder fluxCapacitorBuilder, Function<FluxCapacitor, List<?>> handlersFactory) {
        super(fluxCapacitorBuilder, handlersFactory);
    }

    @Override
    public Registration registerHandlers(List<?> handlers) {
        return this.getFluxCapacitor().registerLocalHandlers(handlers);
    }

    @Override
    public void deregisterHandlers(Registration registration) {
        registration.cancel();
    }

    @Override
    protected Then createResultValidator(Object result) {
        return new ResultValidator(result, this.events, this.commands);
    }

    @Override
    protected void registerCommand(Message command) {
        this.commands.add(command);
    }

    @Override
    protected void registerEvent(Message event) {
        this.events.add(event);
    }

    @Override
    protected Object getDispatchResult(CompletableFuture<?> dispatchResult) {
        return dispatchResult.getNow(null);
    }
}

