/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.test.streaming;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.test.AbstractResultValidator;
import io.fluxcapacitor.javaclient.test.Then;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class AsyncResultValidator
extends AbstractResultValidator {
    private final BlockingQueue<Message> resultingEvents;
    private final BlockingQueue<Message> resultingCommands;

    public AsyncResultValidator(Object actualResult, BlockingQueue<Message> resultingEvents, BlockingQueue<Message> resultingCommands) {
        super(actualResult);
        this.resultingEvents = resultingEvents;
        this.resultingCommands = resultingCommands;
    }

    @Override
    public Then expectOnlyEvents(List<?> events) {
        return this.expectOnlyMessages(events, MessageType.EVENT, this.resultingEvents);
    }

    @Override
    public Then expectEvents(List<?> events) {
        return this.expectMessages(events, MessageType.EVENT, this.resultingEvents);
    }

    @Override
    public Then expectNoEventsLike(List<?> events) {
        return this.expectNoMessagesLike(events, MessageType.EVENT, this.resultingEvents);
    }

    @Override
    public Then expectOnlyCommands(List<?> commands) {
        return this.expectOnlyMessages(commands, MessageType.COMMAND, this.resultingCommands);
    }

    @Override
    public Then expectCommands(List<?> commands) {
        return this.expectMessages(commands, MessageType.COMMAND, this.resultingCommands);
    }

    @Override
    public Then expectNoCommandsLike(List<?> commands) {
        return this.expectNoMessagesLike(commands, MessageType.COMMAND, this.resultingCommands);
    }

    protected Then expectMessages(List<?> messages, MessageType messageType, BlockingQueue<Message> resultingMessages) {
        Collection<?> expected = this.asMessages(messages, messageType);
        Collection<Message> actual = this.getActualMessages(expected, resultingMessages);
        return this.expectMessages(expected, actual);
    }

    protected Then expectOnlyMessages(Collection<?> messages, MessageType messageType, BlockingQueue<Message> resultingMessages) {
        Collection<?> expected = this.asMessages(messages, messageType);
        Collection<Message> actual = this.getActualMessages(expected, resultingMessages);
        return this.expectOnlyMessages(expected, actual);
    }

    protected Then expectNoMessagesLike(Collection<?> messages, MessageType messageType, BlockingQueue<Message> resultingMessages) {
        Collection<?> expected = this.asMessages(messages, messageType);
        Collection<Message> actual = this.getActualMessages(expected, resultingMessages);
        return this.expectNoMessagesLike(expected, actual);
    }

    protected Collection<Message> getActualMessages(Collection<?> expected, BlockingQueue<Message> resultingMessages) {
        ArrayList<Message> result = new ArrayList<Message>();
        try {
            while (!(!expected.isEmpty() && this.containsAll(expected, result) || Thread.interrupted())) {
                Message next = resultingMessages.poll(1L, TimeUnit.SECONDS);
                if (next == null) {
                    return result;
                }
                result.add(next);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return result;
        }
        return result;
    }
}

