package com.farimarwat.composenativeadmob.nativead

import android.content.Context
import android.graphics.drawable.Drawable
import android.view.View
import androidx.compose.foundation.layout.padding
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.toArgb
import androidx.compose.ui.unit.dp
import androidx.compose.ui.viewinterop.AndroidViewBinding
import androidx.core.content.ContextCompat
import com.farimarwat.composenativeadmob.R
import com.farimarwat.composenativeadmob.databinding.NativeAdMediumBinding
import com.farimarwat.composenativeadmob.databinding.NativeAdSmallBinding
import com.google.android.gms.ads.nativead.NativeAd

@Composable
fun BannerAdAdmobSmall(
    context: Context,
    loadedAd: NativeAd?,
    adBackground:Drawable? = null,
    actionButtonBackground:Drawable? = null,
    badgeBackground:Drawable? = null,
    adColors: AdColors = AdColors(),
    ) {
    AndroidViewBinding(
        modifier = Modifier.padding(start = 4.dp, top = 8.dp, end = 4.dp, bottom = 4.dp),
        factory = (NativeAdSmallBinding::inflate)
    ) {
        //setting
        this.container.background = adBackground ?: ContextCompat.getDrawable(context,R.drawable.nativead_background)
        this.adActionbutton.background = actionButtonBackground ?: ContextCompat.getDrawable(context,R.drawable.nativead_button)
        this.adBadge.background = badgeBackground ?: ContextCompat.getDrawable(context,R.drawable.nativead_adtext_background)

        this.adHeadline.setTextColor(adColors.headlineText.toArgb())
        this.adBody.setTextColor(adColors.bodyText.toArgb())
        this.adBadge.setTextColor(adColors.badgeText.toArgb())
        this.adActionbutton.setTextColor(adColors.buttonText.toArgb())
        loadedAd?.let { nativead ->
            // Display the loaded ad
            nativead.icon?.let { icon ->
                this.adIcon.setImageDrawable(icon.drawable)
            }
            nativead.headline?.let { headline ->
                this.adHeadline.text = headline
            }
            nativead.body?.let { body ->
                this.adBody.text = body
            }
            nativead.callToAction?.let { actionbutton ->
                this.adActionbutton.text = actionbutton
                this.nativeadview.callToActionView = this.adActionbutton
            }
            this.nativeadview.setNativeAd(nativead)
        }

    }

}
@Composable
fun BannerAdAdmobMedium(
    context:Context,
    loadedAd: NativeAd?,
    adBackground:Drawable? = null,
    actionButtonBackground:Drawable? = null,
    badgeBackground:Drawable? = null,
    adColors: AdColors = AdColors(),
    ) {
    AndroidViewBinding(
        modifier = Modifier.padding(start = 4.dp, top = 8.dp, end = 4.dp, bottom = 4.dp),
        factory = (NativeAdMediumBinding::inflate)
    ) {
        //setting
        this.container.background = adBackground ?: ContextCompat.getDrawable(context,R.drawable.nativead_background)
        this.adActionbutton.background = actionButtonBackground ?: ContextCompat.getDrawable(context,R.drawable.nativead_button)
        this.adBadge.background = badgeBackground ?: ContextCompat.getDrawable(context,R.drawable.nativead_adtext_background)

        this.adHeadline.setTextColor(adColors.headlineText.toArgb())
        this.adBody.setTextColor(adColors.bodyText.toArgb())
        this.adBadge.setTextColor(adColors.badgeText.toArgb())
        this.adActionbutton.setTextColor(adColors.buttonText.toArgb())

        loadedAd?.let { nativeAd ->
            // Display the loaded ad
            nativeAd.icon?.let { icon ->
                this.adIcon.setImageDrawable(icon.drawable)
            }
            nativeAd.headline?.let { headline ->
                this.adHeadline.text = headline

            }
            nativeAd.body?.let { body ->
                this.adBody.text = body
            }
            //media
            if(nativeAd.mediaContent?.hasVideoContent() == true){
                this.adMedia.mediaContent = nativeAd.mediaContent
                this.adMedia.visibility = View.VISIBLE
            } else {
                if(nativeAd.images.isNotEmpty()){
                    val image = nativeAd.images[0]
                    this.adImage.setImageDrawable(image.drawable)
                    this.adImage.visibility = View.VISIBLE
                }
            }
            //end media
            nativeAd.callToAction?.let { actionbutton ->
                this.adActionbutton.text = actionbutton
                this.nativeadview.callToActionView = this.adActionbutton
            }
            this.nativeadview.setNativeAd(nativeAd)
        }

    }

}



