/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client.nvd;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.github.jeremylong.openvulnerability.client.HttpAsyncClientSupplier;
import io.github.jeremylong.openvulnerability.client.PagedDataSource;
import io.github.jeremylong.openvulnerability.client.nvd.CveApiJson20;
import io.github.jeremylong.openvulnerability.client.nvd.DefCveItem;
import io.github.jeremylong.openvulnerability.client.nvd.NvdApiException;
import io.github.jeremylong.openvulnerability.client.nvd.NvdApiRetryExceededException;
import io.github.jeremylong.openvulnerability.client.nvd.RateLimitedCall;
import io.github.jeremylong.openvulnerability.client.nvd.RateLimitedClient;
import io.github.jeremylong.openvulnerability.client.nvd.RateMeter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NvdCveClient
implements PagedDataSource<DefCveItem> {
    private static final Logger LOG = LoggerFactory.getLogger(NvdCveClient.class);
    private static final String DEFAULT_ENDPOINT = "https://services.nvd.nist.gov/rest/json/cves/2.0";
    private static final String API_KEY_NAME = "apiKey";
    private final String apiKey;
    private final String endpoint;
    private final ObjectMapper objectMapper;
    private final String userAgent;
    private List<RateLimitedClient> clients;
    private final List<Future<RateLimitedCall>> futures = new ArrayList<Future<RateLimitedCall>>();
    private final Map<Integer, Integer> indexesToRetrieve = new HashMap<Integer, Integer>();
    private boolean firstCall = true;
    private int resultsPerPage = 2000;
    private int totalAvailable = -1;
    private final int maxPageCount;
    private List<NameValuePair> filters;
    private int lastStatusCode = 200;
    private ZonedDateTime lastUpdated = null;
    private String version = "unknown";

    NvdCveClient(String apiKey, String endpoint, int threadCount, int maxPageCount) {
        this(apiKey, endpoint, 0L, threadCount, maxPageCount, 10, null);
    }

    NvdCveClient(String apiKey, String endpoint, int threadCount, int maxPageCount, int maxRetryCount) {
        this(apiKey, endpoint, 0L, threadCount, maxPageCount, maxRetryCount, null);
    }

    NvdCveClient(String apiKey, String endpoint, long delay, int threadCount, int maxPageCount, int maxRetryCount, HttpAsyncClientSupplier httpClientSupplier) {
        this(apiKey, endpoint, delay, threadCount, maxPageCount, maxRetryCount, httpClientSupplier, null);
    }

    NvdCveClient(String apiKey, String endpoint, long delay, int threadCount, int maxPageCount, int maxRetryCount, HttpAsyncClientSupplier httpClientSupplier, String userAgent) {
        RateMeter meter;
        this.apiKey = apiKey;
        this.userAgent = userAgent;
        this.endpoint = endpoint == null ? DEFAULT_ENDPOINT : endpoint;
        if (threadCount <= 0) {
            threadCount = 1;
        }
        this.maxPageCount = maxPageCount;
        if (apiKey == null) {
            if (threadCount > 1) {
                LOG.warn("No api key provided; as such the thread count has been reset to 1 instead of the requested {}", (Object)threadCount);
                threadCount = 1;
            }
            meter = new RateMeter(5, 32500L);
        } else {
            meter = new RateMeter(50, 32500L);
        }
        this.clients = new ArrayList<RateLimitedClient>(threadCount);
        if (delay == 0L) {
            delay = apiKey == null ? 6500L : 600L;
        }
        for (int i = 0; i < threadCount; ++i) {
            this.clients.add(new RateLimitedClient(maxRetryCount, delay, meter, httpClientSupplier));
        }
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        try {
            Properties props = new Properties();
            props.load(this.getClass().getClassLoader().getResourceAsStream("version.properties"));
            this.version = props.getProperty("version");
        }
        catch (IOException e) {
            LOG.debug("Error loading version.properties", (Throwable)e);
        }
    }

    void setFilters(List<NameValuePair> filters) {
        this.filters = filters;
    }

    void setResultsPerPage(int resultsPerPage) {
        this.resultsPerPage = resultsPerPage;
    }

    @Override
    public int getLastStatusCode() {
        return this.lastStatusCode;
    }

    @Override
    public int getTotalAvailable() {
        return this.totalAvailable;
    }

    private Future<RateLimitedCall> callApi(int clientIndex, int startIndex) throws NvdApiException {
        try {
            URIBuilder uriBuilder = new URIBuilder(this.endpoint);
            if (this.filters != null) {
                uriBuilder.addParameters(this.filters);
            }
            uriBuilder.addParameter("resultsPerPage", Integer.toString(this.resultsPerPage));
            uriBuilder.addParameter("startIndex", Integer.toString(startIndex));
            SimpleRequestBuilder builder = SimpleRequestBuilder.get();
            if (this.apiKey != null) {
                builder.addHeader(API_KEY_NAME, this.apiKey);
            }
            String ua = "open-vulnerability-client/" + this.version;
            if (this.userAgent != null) {
                ua = ua + "; " + this.userAgent;
            }
            builder.addHeader("User-Agent", ua);
            URI uri = uriBuilder.build();
            LOG.debug("requesting URI: {}", (Object)uri.toString());
            SimpleHttpRequest request = builder.setUri(uri).build();
            return this.clients.get(clientIndex).execute(request, clientIndex, startIndex);
        }
        catch (URISyntaxException e) {
            throw new NvdApiException(e);
        }
    }

    @Override
    public void close() {
        this.indexesToRetrieve.clear();
        if (this.futures.size() > 0) {
            for (Future future : this.futures) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
            this.futures.clear();
        }
        if (this.clients != null) {
            for (RateLimitedClient rateLimitedClient : this.clients) {
                try {
                    rateLimitedClient.close();
                }
                catch (Exception ex) {
                    LOG.debug("Error closing client during `close`", (Throwable)ex);
                }
            }
            this.clients = null;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.lastStatusCode != 200) {
            return false;
        }
        if (this.firstCall) {
            return true;
        }
        if (this.futures.isEmpty() && !this.indexesToRetrieve.isEmpty()) {
            this.queueUnsuccessful();
        }
        return !this.futures.isEmpty();
    }

    @Override
    public Collection<DefCveItem> next() {
        return this._next(0);
    }

    private Collection<DefCveItem> _next(int retryCount) {
        block19: {
            if (retryCount > 5) {
                throw new NvdApiRetryExceededException("NVD Update Failed: attempted to retrieve data from the NVD unsuccessfully five times.");
            }
            if (this.firstCall) {
                this.futures.add(this.callApi(0, 0));
            }
            try {
                RateLimitedCall call = this.getCompletedFuture();
                if (call == null) {
                    if (this.hasNext()) {
                        return this._next(retryCount + 1);
                    }
                    break block19;
                }
                SimpleHttpResponse response = call.getResponse();
                if (response.getCode() == 200) {
                    CveApiJson20 current;
                    LOG.debug("Content-Type Received: {}", (Object)response.getContentType());
                    String json = new String(response.getBodyBytes(), StandardCharsets.UTF_8);
                    try {
                        current = (CveApiJson20)this.objectMapper.readValue(json, CveApiJson20.class);
                        this.indexesToRetrieve.remove(call.getStartIndex());
                    }
                    catch (JsonMappingException e) {
                        LOG.debug("Error parsing NVD data", (Throwable)e);
                        throw new NvdApiException("Failed to parse NVD data", e);
                    }
                    catch (JsonProcessingException e) {
                        LOG.debug("Error processing NVD data", (Throwable)e);
                        return this._next(retryCount + 1);
                    }
                    this.totalAvailable = current.getTotalResults();
                    this.lastUpdated = this.findLastUpdated(this.lastUpdated, current.getVulnerabilities());
                    if (this.firstCall) {
                        this.firstCall = false;
                        this.queueCalls();
                    }
                    if (this.futures.isEmpty() && !this.indexesToRetrieve.isEmpty()) {
                        this.queueUnsuccessful();
                    }
                    return current.getVulnerabilities();
                }
                this.lastStatusCode = response.getCode();
                LOG.debug("Status Code: {}", (Object)this.lastStatusCode);
                LOG.debug("Reason: {}", (Object)response.getReasonPhrase());
                LOG.debug("Response Headers:");
                Header[] headers = response.getHeaders();
                String msg = null;
                for (Header header : headers) {
                    LOG.debug("Key : " + header.getName() + " ,Value : " + header.getValue());
                    if (!"message".equals(header.getName())) continue;
                    msg = header.getValue();
                }
                LOG.debug("Response: {}", (Object)new String(response.getBodyBytes(), StandardCharsets.UTF_8));
                if (msg != null) {
                    if ((msg = msg.trim()).contains("Invalid apiKey")) {
                        String masked;
                        if (this.apiKey.length() > 30) {
                            masked = String.format("Invalid API Key: %s-*****-%s", this.apiKey.substring(0, 5), this.apiKey.substring(this.apiKey.length() - 5, this.apiKey.length()));
                            throw new NvdApiException(masked);
                        }
                        masked = String.format("Invalid API Key: %s-*****", this.apiKey.substring(0, 5));
                        throw new NvdApiException(masked);
                    }
                    if (msg.startsWith("resultsPerPage parameter cannot exceed")) {
                        this.resultsPerPage = this.parseResultsPerPage(msg);
                        LOG.warn(msg);
                        LOG.warn("NVD requested a lower resultsPerPage; settings to {}", (Object)this.resultsPerPage);
                        return this._next(retryCount + 1);
                    }
                    throw new NvdApiException("NVD Returned Status Code: " + this.lastStatusCode + " - " + msg);
                }
                throw new NvdApiException("NVD Returned Status Code: " + this.lastStatusCode);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.close();
                throw new NvdApiException(e);
            }
            catch (ExecutionException e) {
                LOG.debug("Error retrieving the NVD data", (Throwable)e);
                if (this.hasNext()) {
                    return this._next(retryCount + 1);
                }
                this.close();
            }
        }
        return null;
    }

    protected int parseResultsPerPage(String msg) {
        String value = msg;
        if (value.endsWith(".")) {
            value = value.substring(0, value.length() - 1);
        }
        value = value.substring(msg.lastIndexOf(" ") + 1);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            LOG.debug("Error parsing " + msg, (Throwable)e);
            return this.resultsPerPage;
        }
    }

    private ZonedDateTime findLastUpdated(ZonedDateTime lastUpdated, List<DefCveItem> list) {
        ZonedDateTime current = lastUpdated;
        for (DefCveItem item : list) {
            if (current != null && current.compareTo(item.getCve().getLastModified()) >= 0) continue;
            current = item.getCve().getLastModified();
        }
        return current;
    }

    @Override
    public ZonedDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    private RateLimitedCall getCompletedFuture() throws InterruptedException, ExecutionException {
        Future<RateLimitedCall> result = null;
        while (result == null && !this.futures.isEmpty()) {
            for (Future<RateLimitedCall> future : this.futures) {
                if (!future.isDone()) continue;
                result = future;
                break;
            }
            if (result != null) continue;
            Thread.sleep(500L);
        }
        if (result != null) {
            this.futures.remove(result);
            return (RateLimitedCall)result.get();
        }
        return null;
    }

    private void queueUnsuccessful() {
        int clientIndex = 0;
        for (Map.Entry<Integer, Integer> i : this.indexesToRetrieve.entrySet()) {
            if (i.getValue() > 5) {
                throw new NvdApiRetryExceededException("NVD Update Failed: attempted to retrieve starting index " + i.getKey() + " from the NVD unsuccessfully five times.");
            }
            i.setValue(i.getValue() + 1);
            this.futures.add(this.callApi(clientIndex, i.getKey()));
            if (++clientIndex < this.clients.size()) continue;
            clientIndex = 0;
        }
    }

    private void queueCalls() {
        int clientIndex = 0;
        int pageCount = 1;
        for (int i = this.resultsPerPage; (this.maxPageCount <= 0 || pageCount < this.maxPageCount) && i < this.totalAvailable; i += this.resultsPerPage) {
            this.indexesToRetrieve.put(i, 0);
            this.futures.add(this.callApi(clientIndex, i));
            ++pageCount;
            if (++clientIndex < this.clients.size()) continue;
            clientIndex = 0;
        }
    }
}

