/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.springboot3.circuitbreaker.autoconfigure;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.micrometer.tagged.TaggedCircuitBreakerMetrics;
import io.github.resilience4j.micrometer.tagged.TaggedCircuitBreakerMetricsPublisher;
import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MeterRegistry.class, CircuitBreaker.class, TaggedCircuitBreakerMetricsPublisher.class})
@AutoConfigureAfter(name={"org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration"})
@ConditionalOnProperty(value={"resilience4j.circuitbreaker.metrics.enabled"}, matchIfMissing=true)
public class CircuitBreakerMetricsAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"resilience4j.circuitbreaker.metrics.legacy.enabled"}, havingValue="true")
    @ConditionalOnMissingBean
    public TaggedCircuitBreakerMetrics registerCircuitBreakerMetrics(CircuitBreakerRegistry circuitBreakerRegistry) {
        return TaggedCircuitBreakerMetrics.ofCircuitBreakerRegistry((CircuitBreakerRegistry)circuitBreakerRegistry);
    }

    @Bean
    @ConditionalOnBean(value={MeterRegistry.class})
    @ConditionalOnProperty(value={"resilience4j.circuitbreaker.metrics.legacy.enabled"}, havingValue="false", matchIfMissing=true)
    @ConditionalOnMissingBean
    public TaggedCircuitBreakerMetricsPublisher taggedCircuitBreakerMetricsPublisher(MeterRegistry meterRegistry) {
        return new TaggedCircuitBreakerMetricsPublisher(meterRegistry);
    }
}

