/*
 * Decompiled with CFR 0.152.
 */
package io.keen.client.java;

import io.keen.client.java.FilterOperator;
import io.keen.client.java.QueryType;
import io.keen.client.java.Timeframe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Query {
    private final QueryType queryType;
    private final String eventCollection;
    private final String targetProperty;
    private final Timeframe timeframe;
    private final List<Map<String, Object>> filters;
    private final String interval;
    private final String timezone;
    private final List<String> groupBy;
    private final Integer maxAge;
    private final Double percentile;

    public Map<String, Object> constructQueryArgs() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (this.eventCollection != null) {
            queryArgs.put("event_collection", this.eventCollection);
        }
        if (this.interval != null) {
            queryArgs.put("interval", this.interval);
        }
        if (this.timezone != null) {
            queryArgs.put("timezone", this.timezone);
        }
        if (this.groupBy != null) {
            queryArgs.put("group_by", this.groupBy);
        }
        if (this.maxAge != null) {
            queryArgs.put("max_age", this.maxAge);
        }
        if (this.targetProperty != null) {
            queryArgs.put("target_property", this.targetProperty);
        }
        if (this.percentile != null) {
            queryArgs.put("percentile", this.percentile);
        }
        if (this.filters != null && !this.filters.isEmpty()) {
            queryArgs.put("filters", this.filters);
        }
        if (this.timeframe != null) {
            queryArgs.putAll(this.timeframe.constructTimeframeArgs());
        }
        return queryArgs;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public boolean hasGroupBy() {
        return this.groupBy != null;
    }

    public boolean hasInterval() {
        return this.interval != null;
    }

    public boolean areParamsValid() {
        if (this.queryType == QueryType.COUNT && (this.eventCollection == null || this.eventCollection.isEmpty())) {
            return false;
        }
        if ((this.queryType == QueryType.COUNT_UNIQUE || this.queryType == QueryType.MINIMUM || this.queryType == QueryType.MAXIMUM || this.queryType == QueryType.AVERAGE || this.queryType == QueryType.MEDIAN || this.queryType == QueryType.PERCENTILE || this.queryType == QueryType.SUM || this.queryType == QueryType.SELECT_UNIQUE) && (this.eventCollection == null || this.eventCollection.isEmpty() || this.targetProperty == null || this.targetProperty.isEmpty())) {
            return false;
        }
        return this.queryType != QueryType.PERCENTILE || this.percentile != null;
    }

    protected Query(Builder builder) {
        this.eventCollection = builder.eventCollection;
        this.targetProperty = builder.targetProperty;
        this.interval = builder.interval;
        this.timezone = builder.timezone;
        this.groupBy = builder.groupBy;
        this.maxAge = builder.maxAge;
        this.percentile = builder.percentile;
        this.queryType = builder.queryType;
        this.timeframe = builder.timeframe;
        this.filters = builder.filters;
    }

    public static class Builder {
        private QueryType queryType;
        private String eventCollection;
        private String targetProperty;
        private Double percentile;
        private Timeframe timeframe;
        private List<Map<String, Object>> filters;
        private String interval;
        private String timezone;
        private ArrayList<String> groupBy;
        private Integer maxAge;

        public Builder(QueryType queryType) {
            this.queryType = queryType;
        }

        public List<Map<String, Object>> getFilters() {
            return this.filters;
        }

        public void setFilters(List<Map<String, Object>> filters) {
            this.filters = filters;
        }

        public Builder withFilters(List<Map<String, Object>> filters) {
            this.setFilters(filters);
            return this;
        }

        public Builder withFilter(String propertyName, FilterOperator operator, Object propertyValue) {
            HashMap<String, Object> filter = new HashMap<String, Object>();
            filter.put("property_name", propertyName);
            filter.put("operator", operator.toString());
            filter.put("property_value", propertyValue);
            if (this.filters == null) {
                this.filters = new ArrayList<Map<String, Object>>();
            }
            this.filters.add(filter);
            return this;
        }

        public String getEventCollection() {
            return this.eventCollection;
        }

        public void setEventCollection(String eventCollection) {
            this.eventCollection = eventCollection;
        }

        public Builder withEventCollection(String eventCollection) {
            this.setEventCollection(eventCollection);
            return this;
        }

        public String getTargetProperty() {
            return this.targetProperty;
        }

        public void setTargetProperty(String targetProperty) {
            this.targetProperty = targetProperty;
        }

        public Builder withTargetProperty(String targetProperty) {
            this.setTargetProperty(targetProperty);
            return this;
        }

        public String getInterval() {
            return this.interval;
        }

        public void setInterval(String interval) {
            this.interval = interval;
        }

        public Builder withInterval(String interval) {
            this.setInterval(interval);
            return this;
        }

        public String getTimezone() {
            return this.timezone;
        }

        public void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public Builder withTimezone(String timezone) {
            this.setTimezone(timezone);
            return this;
        }

        public ArrayList<String> getGroupBy() {
            return this.groupBy;
        }

        public void setGroupBy(ArrayList<String> groupBy) {
            this.groupBy = groupBy;
        }

        public Builder withGroupBy(String groupBy) {
            if (this.groupBy == null) {
                this.groupBy = new ArrayList();
            }
            this.groupBy.add(groupBy);
            return this;
        }

        public Builder withGroupBy(ArrayList<String> groupBy) {
            this.setGroupBy(groupBy);
            return this;
        }

        public Integer getMaxAge() {
            return this.maxAge;
        }

        public void setMaxAge(Integer maxAge) {
            this.maxAge = maxAge;
        }

        public Builder withMaxAge(Integer maxAge) {
            this.setMaxAge(maxAge);
            return this;
        }

        public Double getPercentile() {
            return this.percentile;
        }

        public void setPercentile(Double percentile) {
            this.percentile = percentile;
        }

        public void setPercentile(Integer percentile) {
            this.percentile = percentile.doubleValue();
        }

        public Builder withPercentile(Double percentile) {
            this.setPercentile(percentile);
            return this;
        }

        public Builder withPercentile(Integer percentile) {
            this.setPercentile(percentile.doubleValue());
            return this;
        }

        public Timeframe getTimeframe() {
            return this.timeframe;
        }

        public void setTimeframe(Timeframe timeframe) {
            this.timeframe = timeframe;
        }

        public Builder withTimeframe(Timeframe timeframe) {
            this.setTimeframe(timeframe);
            return this;
        }

        public Query build() {
            return new Query(this);
        }
    }
}

