package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ExtensionsV1beta1HTTPIngressRuleValueFluentImpl<A extends ExtensionsV1beta1HTTPIngressRuleValueFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements ExtensionsV1beta1HTTPIngressRuleValueFluent<A>{

    private List<ExtensionsV1beta1HTTPIngressPathBuilder> paths;

    public ExtensionsV1beta1HTTPIngressRuleValueFluentImpl(){
    }
    public ExtensionsV1beta1HTTPIngressRuleValueFluentImpl(ExtensionsV1beta1HTTPIngressRuleValue instance){
            this.withPaths(instance.getPaths());

    }

    public A addToPaths(int index,ExtensionsV1beta1HTTPIngressPath item){
            if (this.paths == null) {this.paths = new ArrayList<ExtensionsV1beta1HTTPIngressPathBuilder>();}
            ExtensionsV1beta1HTTPIngressPathBuilder builder = new ExtensionsV1beta1HTTPIngressPathBuilder(item);_visitables.get("paths").add(index >= 0 ? index : _visitables.get("paths").size(), builder);this.paths.add(index >= 0 ? index : paths.size(), builder); return (A)this;
    }

    public A setToPaths(int index,ExtensionsV1beta1HTTPIngressPath item){
            if (this.paths == null) {this.paths = new ArrayList<ExtensionsV1beta1HTTPIngressPathBuilder>();}
            ExtensionsV1beta1HTTPIngressPathBuilder builder = new ExtensionsV1beta1HTTPIngressPathBuilder(item);
            if (index < 0 || index >= _visitables.get("paths").size()) { _visitables.get("paths").add(builder); } else { _visitables.get("paths").set(index, builder);}
            if (index < 0 || index >= paths.size()) { paths.add(builder); } else { paths.set(index, builder);}
             return (A)this;
    }

    public A addToPaths(ExtensionsV1beta1HTTPIngressPath... items){
            if (this.paths == null) {this.paths = new ArrayList<ExtensionsV1beta1HTTPIngressPathBuilder>();}
            for (ExtensionsV1beta1HTTPIngressPath item : items) {ExtensionsV1beta1HTTPIngressPathBuilder builder = new ExtensionsV1beta1HTTPIngressPathBuilder(item);_visitables.get("paths").add(builder);this.paths.add(builder);} return (A)this;
    }

    public A addAllToPaths(Collection<ExtensionsV1beta1HTTPIngressPath> items){
            if (this.paths == null) {this.paths = new ArrayList<ExtensionsV1beta1HTTPIngressPathBuilder>();}
            for (ExtensionsV1beta1HTTPIngressPath item : items) {ExtensionsV1beta1HTTPIngressPathBuilder builder = new ExtensionsV1beta1HTTPIngressPathBuilder(item);_visitables.get("paths").add(builder);this.paths.add(builder);} return (A)this;
    }

    public A removeFromPaths(ExtensionsV1beta1HTTPIngressPath... items){
            for (ExtensionsV1beta1HTTPIngressPath item : items) {ExtensionsV1beta1HTTPIngressPathBuilder builder = new ExtensionsV1beta1HTTPIngressPathBuilder(item);_visitables.get("paths").remove(builder);if (this.paths != null) {this.paths.remove(builder);}} return (A)this;
    }

    public A removeAllFromPaths(Collection<ExtensionsV1beta1HTTPIngressPath> items){
            for (ExtensionsV1beta1HTTPIngressPath item : items) {ExtensionsV1beta1HTTPIngressPathBuilder builder = new ExtensionsV1beta1HTTPIngressPathBuilder(item);_visitables.get("paths").remove(builder);if (this.paths != null) {this.paths.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPaths(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1HTTPIngressPathBuilder> predicate){
            if (paths == null) return (A) this;
            final Iterator<ExtensionsV1beta1HTTPIngressPathBuilder> each = paths.iterator();
            final List visitables = _visitables.get("paths");
            while (each.hasNext()) {
              ExtensionsV1beta1HTTPIngressPathBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildPaths instead.
 * @return The buildable object.
 */
@Deprecated public List<ExtensionsV1beta1HTTPIngressPath> getPaths(){
            return build(paths);
    }

    public List<ExtensionsV1beta1HTTPIngressPath> buildPaths(){
            return build(paths);
    }

    public ExtensionsV1beta1HTTPIngressPath buildPath(int index){
            return this.paths.get(index).build();
    }

    public ExtensionsV1beta1HTTPIngressPath buildFirstPath(){
            return this.paths.get(0).build();
    }

    public ExtensionsV1beta1HTTPIngressPath buildLastPath(){
            return this.paths.get(paths.size() - 1).build();
    }

    public ExtensionsV1beta1HTTPIngressPath buildMatchingPath(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1HTTPIngressPathBuilder> predicate){
            for (ExtensionsV1beta1HTTPIngressPathBuilder item: paths) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingPath(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1HTTPIngressPathBuilder> predicate){
            for (ExtensionsV1beta1HTTPIngressPathBuilder item: paths) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withPaths(List<ExtensionsV1beta1HTTPIngressPath> paths){
            if (this.paths != null) { _visitables.get("paths").removeAll(this.paths);}
            if (paths != null) {this.paths = new ArrayList<ExtensionsV1beta1HTTPIngressPathBuilder>(); for (ExtensionsV1beta1HTTPIngressPath item : paths){this.addToPaths(item);}} else { this.paths = null;} return (A) this;
    }

    public A withPaths(ExtensionsV1beta1HTTPIngressPath... paths){
            if (this.paths != null) {this.paths.clear();}
            if (paths != null) {for (ExtensionsV1beta1HTTPIngressPath item :paths){ this.addToPaths(item);}} return (A) this;
    }

    public Boolean hasPaths(){
            return paths != null && !paths.isEmpty();
    }

    public ExtensionsV1beta1HTTPIngressRuleValueFluent.PathsNested<A> addNewPath(){
            return new PathsNestedImpl();
    }

    public ExtensionsV1beta1HTTPIngressRuleValueFluent.PathsNested<A> addNewPathLike(ExtensionsV1beta1HTTPIngressPath item){
            return new PathsNestedImpl(-1, item);
    }

    public ExtensionsV1beta1HTTPIngressRuleValueFluent.PathsNested<A> setNewPathLike(int index,ExtensionsV1beta1HTTPIngressPath item){
            return new PathsNestedImpl(index, item);
    }

    public ExtensionsV1beta1HTTPIngressRuleValueFluent.PathsNested<A> editPath(int index){
            if (paths.size() <= index) throw new RuntimeException("Can't edit paths. Index exceeds size.");
            return setNewPathLike(index, buildPath(index));
    }

    public ExtensionsV1beta1HTTPIngressRuleValueFluent.PathsNested<A> editFirstPath(){
            if (paths.size() == 0) throw new RuntimeException("Can't edit first paths. The list is empty.");
            return setNewPathLike(0, buildPath(0));
    }

    public ExtensionsV1beta1HTTPIngressRuleValueFluent.PathsNested<A> editLastPath(){
            int index = paths.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last paths. The list is empty.");
            return setNewPathLike(index, buildPath(index));
    }

    public ExtensionsV1beta1HTTPIngressRuleValueFluent.PathsNested<A> editMatchingPath(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1HTTPIngressPathBuilder> predicate){
            int index = -1;
            for (int i=0;i<paths.size();i++) { 
            if (predicate.apply(paths.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching paths. No match found.");
            return setNewPathLike(index, buildPath(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ExtensionsV1beta1HTTPIngressRuleValueFluentImpl that = (ExtensionsV1beta1HTTPIngressRuleValueFluentImpl) o;
            if (paths != null ? !paths.equals(that.paths) :that.paths != null) return false;
            return true;
    }


    public class PathsNestedImpl<N> extends ExtensionsV1beta1HTTPIngressPathFluentImpl<ExtensionsV1beta1HTTPIngressRuleValueFluent.PathsNested<N>> implements ExtensionsV1beta1HTTPIngressRuleValueFluent.PathsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final ExtensionsV1beta1HTTPIngressPathBuilder builder;
        private final int index;
    
            PathsNestedImpl(int index,ExtensionsV1beta1HTTPIngressPath item){
                    this.index = index;
                    this.builder = new ExtensionsV1beta1HTTPIngressPathBuilder(this, item);
            }
            PathsNestedImpl(){
                    this.index = -1;
                    this.builder = new ExtensionsV1beta1HTTPIngressPathBuilder(this);
            }
    
    public N and(){
            return (N) ExtensionsV1beta1HTTPIngressRuleValueFluentImpl.this.setToPaths(index,builder.build());
    }
    public N endPath(){
            return and();
    }

}


}
