package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ExtensionsV1beta1IngressRuleFluentImpl<A extends ExtensionsV1beta1IngressRuleFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements ExtensionsV1beta1IngressRuleFluent<A>{

    private String host;
    private ExtensionsV1beta1HTTPIngressRuleValueBuilder http;

    public ExtensionsV1beta1IngressRuleFluentImpl(){
    }
    public ExtensionsV1beta1IngressRuleFluentImpl(ExtensionsV1beta1IngressRule instance){
            this.withHost(instance.getHost());

            this.withHttp(instance.getHttp());

    }

    public String getHost(){
            return this.host;
    }

    public A withHost(String host){
            this.host=host; return (A) this;
    }

    public Boolean hasHost(){
            return this.host != null;
    }

    public A withNewHost(String arg1){
            return (A)withHost(new String(arg1));
    }

    public A withNewHost(StringBuilder arg1){
            return (A)withHost(new String(arg1));
    }

    public A withNewHost(StringBuffer arg1){
            return (A)withHost(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildHttp instead.
 * @return The buildable object.
 */
@Deprecated public ExtensionsV1beta1HTTPIngressRuleValue getHttp(){
            return this.http!=null?this.http.build():null;
    }

    public ExtensionsV1beta1HTTPIngressRuleValue buildHttp(){
            return this.http!=null?this.http.build():null;
    }

    public A withHttp(ExtensionsV1beta1HTTPIngressRuleValue http){
            _visitables.get("http").remove(this.http);
            if (http!=null){ this.http= new ExtensionsV1beta1HTTPIngressRuleValueBuilder(http); _visitables.get("http").add(this.http);} return (A) this;
    }

    public Boolean hasHttp(){
            return this.http != null;
    }

    public ExtensionsV1beta1IngressRuleFluent.HttpNested<A> withNewHttp(){
            return new HttpNestedImpl();
    }

    public ExtensionsV1beta1IngressRuleFluent.HttpNested<A> withNewHttpLike(ExtensionsV1beta1HTTPIngressRuleValue item){
            return new HttpNestedImpl(item);
    }

    public ExtensionsV1beta1IngressRuleFluent.HttpNested<A> editHttp(){
            return withNewHttpLike(getHttp());
    }

    public ExtensionsV1beta1IngressRuleFluent.HttpNested<A> editOrNewHttp(){
            return withNewHttpLike(getHttp() != null ? getHttp(): new ExtensionsV1beta1HTTPIngressRuleValueBuilder().build());
    }

    public ExtensionsV1beta1IngressRuleFluent.HttpNested<A> editOrNewHttpLike(ExtensionsV1beta1HTTPIngressRuleValue item){
            return withNewHttpLike(getHttp() != null ? getHttp(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ExtensionsV1beta1IngressRuleFluentImpl that = (ExtensionsV1beta1IngressRuleFluentImpl) o;
            if (host != null ? !host.equals(that.host) :that.host != null) return false;
            if (http != null ? !http.equals(that.http) :that.http != null) return false;
            return true;
    }


    public class HttpNestedImpl<N> extends ExtensionsV1beta1HTTPIngressRuleValueFluentImpl<ExtensionsV1beta1IngressRuleFluent.HttpNested<N>> implements ExtensionsV1beta1IngressRuleFluent.HttpNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final ExtensionsV1beta1HTTPIngressRuleValueBuilder builder;
    
            HttpNestedImpl(ExtensionsV1beta1HTTPIngressRuleValue item){
                    this.builder = new ExtensionsV1beta1HTTPIngressRuleValueBuilder(this, item);
            }
            HttpNestedImpl(){
                    this.builder = new ExtensionsV1beta1HTTPIngressRuleValueBuilder(this);
            }
    
    public N and(){
            return (N) ExtensionsV1beta1IngressRuleFluentImpl.this.withHttp(builder.build());
    }
    public N endHttp(){
            return and();
    }

}


}
