package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExtensionsV1beta1IngressStatusBuilder extends ExtensionsV1beta1IngressStatusFluentImpl<ExtensionsV1beta1IngressStatusBuilder> implements VisitableBuilder<ExtensionsV1beta1IngressStatus,ExtensionsV1beta1IngressStatusBuilder>{

    ExtensionsV1beta1IngressStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ExtensionsV1beta1IngressStatusBuilder(){
            this(true);
    }
    public ExtensionsV1beta1IngressStatusBuilder(Boolean validationEnabled){
            this(new ExtensionsV1beta1IngressStatus(), validationEnabled);
    }
    public ExtensionsV1beta1IngressStatusBuilder(ExtensionsV1beta1IngressStatusFluent<?> fluent){
            this(fluent, true);
    }
    public ExtensionsV1beta1IngressStatusBuilder(ExtensionsV1beta1IngressStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExtensionsV1beta1IngressStatus(), validationEnabled);
    }
    public ExtensionsV1beta1IngressStatusBuilder(ExtensionsV1beta1IngressStatusFluent<?> fluent,ExtensionsV1beta1IngressStatus instance){
            this(fluent, instance, true);
    }
    public ExtensionsV1beta1IngressStatusBuilder(ExtensionsV1beta1IngressStatusFluent<?> fluent,ExtensionsV1beta1IngressStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLoadBalancer(instance.getLoadBalancer());

            this.validationEnabled = validationEnabled; 
    }
    public ExtensionsV1beta1IngressStatusBuilder(ExtensionsV1beta1IngressStatus instance){
            this(instance,true);
    }
    public ExtensionsV1beta1IngressStatusBuilder(ExtensionsV1beta1IngressStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLoadBalancer(instance.getLoadBalancer());

            this.validationEnabled = validationEnabled; 
    }

    public ExtensionsV1beta1IngressStatus build(){
            ExtensionsV1beta1IngressStatus buildable = new ExtensionsV1beta1IngressStatus();
            buildable.setLoadBalancer(fluent.getLoadBalancer());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExtensionsV1beta1IngressStatusBuilder that = (ExtensionsV1beta1IngressStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
