package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NetworkingV1beta1IngressTLSBuilder extends NetworkingV1beta1IngressTLSFluentImpl<NetworkingV1beta1IngressTLSBuilder> implements VisitableBuilder<NetworkingV1beta1IngressTLS,NetworkingV1beta1IngressTLSBuilder>{

    NetworkingV1beta1IngressTLSFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkingV1beta1IngressTLSBuilder(){
            this(true);
    }
    public NetworkingV1beta1IngressTLSBuilder(Boolean validationEnabled){
            this(new NetworkingV1beta1IngressTLS(), validationEnabled);
    }
    public NetworkingV1beta1IngressTLSBuilder(NetworkingV1beta1IngressTLSFluent<?> fluent){
            this(fluent, true);
    }
    public NetworkingV1beta1IngressTLSBuilder(NetworkingV1beta1IngressTLSFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NetworkingV1beta1IngressTLS(), validationEnabled);
    }
    public NetworkingV1beta1IngressTLSBuilder(NetworkingV1beta1IngressTLSFluent<?> fluent,NetworkingV1beta1IngressTLS instance){
            this(fluent, instance, true);
    }
    public NetworkingV1beta1IngressTLSBuilder(NetworkingV1beta1IngressTLSFluent<?> fluent,NetworkingV1beta1IngressTLS instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHosts(instance.getHosts());

            fluent.withSecretName(instance.getSecretName());

            this.validationEnabled = validationEnabled; 
    }
    public NetworkingV1beta1IngressTLSBuilder(NetworkingV1beta1IngressTLS instance){
            this(instance,true);
    }
    public NetworkingV1beta1IngressTLSBuilder(NetworkingV1beta1IngressTLS instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHosts(instance.getHosts());

            this.withSecretName(instance.getSecretName());

            this.validationEnabled = validationEnabled; 
    }

    public NetworkingV1beta1IngressTLS build(){
            NetworkingV1beta1IngressTLS buildable = new NetworkingV1beta1IngressTLS();
            buildable.setHosts(fluent.getHosts());
            buildable.setSecretName(fluent.getSecretName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NetworkingV1beta1IngressTLSBuilder that = (NetworkingV1beta1IngressTLSBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
