package io.kubernetes.client.openapi.models;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import io.kubernetes.client.fluent.Predicate;

public interface V1APIResourceFluent<A extends V1APIResourceFluent<A>> extends Fluent<A>{


    public A addToCategories(int index,String item);
    public A setToCategories(int index,String item);
    public A addToCategories(String... items);
    public A addAllToCategories(Collection<String> items);
    public A removeFromCategories(String... items);
    public A removeAllFromCategories(Collection<String> items);
    public List<String> getCategories();
    public String getCategory(int index);
    public String getFirstCategory();
    public String getLastCategory();
    public String getMatchingCategory(io.kubernetes.client.fluent.Predicate<String> predicate);
    public Boolean hasMatchingCategory(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withCategories(List<String> categories);
    public A withCategories(String... categories);
    public Boolean hasCategories();
    public A addNewCategory(String arg1);
    public A addNewCategory(StringBuilder arg1);
    public A addNewCategory(StringBuffer arg1);
    public String getGroup();
    public A withGroup(String group);
    public Boolean hasGroup();
    public A withNewGroup(String arg1);
    public A withNewGroup(StringBuilder arg1);
    public A withNewGroup(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    public Boolean isNamespaced();
    public A withNamespaced(Boolean namespaced);
    public Boolean hasNamespaced();
    public A withNewNamespaced(String arg1);
    public A withNewNamespaced(boolean arg1);
    public A addToShortNames(int index,String item);
    public A setToShortNames(int index,String item);
    public A addToShortNames(String... items);
    public A addAllToShortNames(Collection<String> items);
    public A removeFromShortNames(String... items);
    public A removeAllFromShortNames(Collection<String> items);
    public List<String> getShortNames();
    public String getShortName(int index);
    public String getFirstShortName();
    public String getLastShortName();
    public String getMatchingShortName(io.kubernetes.client.fluent.Predicate<String> predicate);
    public Boolean hasMatchingShortName(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withShortNames(List<String> shortNames);
    public A withShortNames(String... shortNames);
    public Boolean hasShortNames();
    public A addNewShortName(String arg1);
    public A addNewShortName(StringBuilder arg1);
    public A addNewShortName(StringBuffer arg1);
    public String getSingularName();
    public A withSingularName(String singularName);
    public Boolean hasSingularName();
    public A withNewSingularName(String arg1);
    public A withNewSingularName(StringBuilder arg1);
    public A withNewSingularName(StringBuffer arg1);
    public String getStorageVersionHash();
    public A withStorageVersionHash(String storageVersionHash);
    public Boolean hasStorageVersionHash();
    public A withNewStorageVersionHash(String arg1);
    public A withNewStorageVersionHash(StringBuilder arg1);
    public A withNewStorageVersionHash(StringBuffer arg1);
    public A addToVerbs(int index,String item);
    public A setToVerbs(int index,String item);
    public A addToVerbs(String... items);
    public A addAllToVerbs(Collection<String> items);
    public A removeFromVerbs(String... items);
    public A removeAllFromVerbs(Collection<String> items);
    public List<String> getVerbs();
    public String getVerb(int index);
    public String getFirstVerb();
    public String getLastVerb();
    public String getMatchingVerb(io.kubernetes.client.fluent.Predicate<String> predicate);
    public Boolean hasMatchingVerb(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withVerbs(List<String> verbs);
    public A withVerbs(String... verbs);
    public Boolean hasVerbs();
    public A addNewVerb(String arg1);
    public A addNewVerb(StringBuilder arg1);
    public A addNewVerb(StringBuffer arg1);
    public String getVersion();
    public A withVersion(String version);
    public Boolean hasVersion();
    public A withNewVersion(String arg1);
    public A withNewVersion(StringBuilder arg1);
    public A withNewVersion(StringBuffer arg1);



}
