package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1APIServiceListFluent<A extends V1APIServiceListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,V1APIService item);
    public A setToItems(int index,V1APIService item);
    public A addToItems(V1APIService... items);
    public A addAllToItems(Collection<V1APIService> items);
    public A removeFromItems(V1APIService... items);
    public A removeAllFromItems(Collection<V1APIService> items);
    public A removeMatchingFromItems(io.kubernetes.client.fluent.Predicate<V1APIServiceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<V1APIService> getItems();
    public List<V1APIService> buildItems();
    public V1APIService buildItem(int index);
    public V1APIService buildFirstItem();
    public V1APIService buildLastItem();
    public V1APIService buildMatchingItem(io.kubernetes.client.fluent.Predicate<V1APIServiceBuilder> predicate);
    public Boolean hasMatchingItem(io.kubernetes.client.fluent.Predicate<V1APIServiceBuilder> predicate);
    public A withItems(List<V1APIService> items);
    public A withItems(V1APIService... items);
    public Boolean hasItems();
    public V1APIServiceListFluent.ItemsNested<A> addNewItem();
    public V1APIServiceListFluent.ItemsNested<A> addNewItemLike(V1APIService item);
    public V1APIServiceListFluent.ItemsNested<A> setNewItemLike(int index,V1APIService item);
    public V1APIServiceListFluent.ItemsNested<A> editItem(int index);
    public V1APIServiceListFluent.ItemsNested<A> editFirstItem();
    public V1APIServiceListFluent.ItemsNested<A> editLastItem();
    public V1APIServiceListFluent.ItemsNested<A> editMatchingItem(io.kubernetes.client.fluent.Predicate<V1APIServiceBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ListMeta getMetadata();
    public V1ListMeta buildMetadata();
    public A withMetadata(V1ListMeta metadata);
    public Boolean hasMetadata();
    public V1APIServiceListFluent.MetadataNested<A> withNewMetadata();
    public V1APIServiceListFluent.MetadataNested<A> withNewMetadataLike(V1ListMeta item);
    public V1APIServiceListFluent.MetadataNested<A> editMetadata();
    public V1APIServiceListFluent.MetadataNested<A> editOrNewMetadata();
    public V1APIServiceListFluent.MetadataNested<A> editOrNewMetadataLike(V1ListMeta item);

    public interface ItemsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1APIServiceFluent<V1APIServiceListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ListMetaFluent<V1APIServiceListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
