package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Byte;
import java.util.Collection;
import java.lang.Boolean;

public interface V1APIServiceSpecFluent<A extends V1APIServiceSpecFluent<A>> extends Fluent<A>{


    public A withCaBundle(byte... caBundle);
    public byte[] getCaBundle();
    public A addToCaBundle(int index,Byte item);
    public A setToCaBundle(int index,Byte item);
    public A addToCaBundle(Byte... items);
    public A addAllToCaBundle(Collection<Byte> items);
    public A removeFromCaBundle(Byte... items);
    public A removeAllFromCaBundle(Collection<Byte> items);
    public Boolean hasCaBundle();
    public A addNewCaBundle(String arg1);
    public A addNewCaBundle(byte arg1);
    public String getGroup();
    public A withGroup(String group);
    public Boolean hasGroup();
    public A withNewGroup(String arg1);
    public A withNewGroup(StringBuilder arg1);
    public A withNewGroup(StringBuffer arg1);
    public Integer getGroupPriorityMinimum();
    public A withGroupPriorityMinimum(Integer groupPriorityMinimum);
    public Boolean hasGroupPriorityMinimum();
    public Boolean isInsecureSkipTLSVerify();
    public A withInsecureSkipTLSVerify(Boolean insecureSkipTLSVerify);
    public Boolean hasInsecureSkipTLSVerify();
    public A withNewInsecureSkipTLSVerify(String arg1);
    public A withNewInsecureSkipTLSVerify(boolean arg1);
    
/**
 * This method has been deprecated, please use method buildService instead.
 * @return The buildable object.
 */
@Deprecated public ApiregistrationV1ServiceReference getService();
    public ApiregistrationV1ServiceReference buildService();
    public A withService(ApiregistrationV1ServiceReference service);
    public Boolean hasService();
    public V1APIServiceSpecFluent.ServiceNested<A> withNewService();
    public V1APIServiceSpecFluent.ServiceNested<A> withNewServiceLike(ApiregistrationV1ServiceReference item);
    public V1APIServiceSpecFluent.ServiceNested<A> editService();
    public V1APIServiceSpecFluent.ServiceNested<A> editOrNewService();
    public V1APIServiceSpecFluent.ServiceNested<A> editOrNewServiceLike(ApiregistrationV1ServiceReference item);
    public String getVersion();
    public A withVersion(String version);
    public Boolean hasVersion();
    public A withNewVersion(String arg1);
    public A withNewVersion(StringBuilder arg1);
    public A withNewVersion(StringBuffer arg1);
    public Integer getVersionPriority();
    public A withVersionPriority(Integer versionPriority);
    public Boolean hasVersionPriority();

    public interface ServiceNested<N> extends io.kubernetes.client.fluent.Nested<N>,ApiregistrationV1ServiceReferenceFluent<V1APIServiceSpecFluent.ServiceNested<N>>{

        
    public N and();    public N endService();
}


}
