package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1CSIDriverListFluent<A extends V1CSIDriverListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,V1CSIDriver item);
    public A setToItems(int index,V1CSIDriver item);
    public A addToItems(V1CSIDriver... items);
    public A addAllToItems(Collection<V1CSIDriver> items);
    public A removeFromItems(V1CSIDriver... items);
    public A removeAllFromItems(Collection<V1CSIDriver> items);
    public A removeMatchingFromItems(io.kubernetes.client.fluent.Predicate<V1CSIDriverBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<V1CSIDriver> getItems();
    public List<V1CSIDriver> buildItems();
    public V1CSIDriver buildItem(int index);
    public V1CSIDriver buildFirstItem();
    public V1CSIDriver buildLastItem();
    public V1CSIDriver buildMatchingItem(io.kubernetes.client.fluent.Predicate<V1CSIDriverBuilder> predicate);
    public Boolean hasMatchingItem(io.kubernetes.client.fluent.Predicate<V1CSIDriverBuilder> predicate);
    public A withItems(List<V1CSIDriver> items);
    public A withItems(V1CSIDriver... items);
    public Boolean hasItems();
    public V1CSIDriverListFluent.ItemsNested<A> addNewItem();
    public V1CSIDriverListFluent.ItemsNested<A> addNewItemLike(V1CSIDriver item);
    public V1CSIDriverListFluent.ItemsNested<A> setNewItemLike(int index,V1CSIDriver item);
    public V1CSIDriverListFluent.ItemsNested<A> editItem(int index);
    public V1CSIDriverListFluent.ItemsNested<A> editFirstItem();
    public V1CSIDriverListFluent.ItemsNested<A> editLastItem();
    public V1CSIDriverListFluent.ItemsNested<A> editMatchingItem(io.kubernetes.client.fluent.Predicate<V1CSIDriverBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ListMeta getMetadata();
    public V1ListMeta buildMetadata();
    public A withMetadata(V1ListMeta metadata);
    public Boolean hasMetadata();
    public V1CSIDriverListFluent.MetadataNested<A> withNewMetadata();
    public V1CSIDriverListFluent.MetadataNested<A> withNewMetadataLike(V1ListMeta item);
    public V1CSIDriverListFluent.MetadataNested<A> editMetadata();
    public V1CSIDriverListFluent.MetadataNested<A> editOrNewMetadata();
    public V1CSIDriverListFluent.MetadataNested<A> editOrNewMetadataLike(V1ListMeta item);

    public interface ItemsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1CSIDriverFluent<V1CSIDriverListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ListMetaFluent<V1CSIDriverListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
