package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class V1CSIVolumeSourceFluentImpl<A extends V1CSIVolumeSourceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1CSIVolumeSourceFluent<A>{

    private String driver;
    private String fsType;
    private V1LocalObjectReferenceBuilder nodePublishSecretRef;
    private Boolean readOnly;
    private Map<String,String> volumeAttributes;

    public V1CSIVolumeSourceFluentImpl(){
    }
    public V1CSIVolumeSourceFluentImpl(V1CSIVolumeSource instance){
            this.withDriver(instance.getDriver());

            this.withFsType(instance.getFsType());

            this.withNodePublishSecretRef(instance.getNodePublishSecretRef());

            this.withReadOnly(instance.getReadOnly());

            this.withVolumeAttributes(instance.getVolumeAttributes());

    }

    public String getDriver(){
            return this.driver;
    }

    public A withDriver(String driver){
            this.driver=driver; return (A) this;
    }

    public Boolean hasDriver(){
            return this.driver != null;
    }

    public A withNewDriver(String arg1){
            return (A)withDriver(new String(arg1));
    }

    public A withNewDriver(StringBuilder arg1){
            return (A)withDriver(new String(arg1));
    }

    public A withNewDriver(StringBuffer arg1){
            return (A)withDriver(new String(arg1));
    }

    public String getFsType(){
            return this.fsType;
    }

    public A withFsType(String fsType){
            this.fsType=fsType; return (A) this;
    }

    public Boolean hasFsType(){
            return this.fsType != null;
    }

    public A withNewFsType(String arg1){
            return (A)withFsType(new String(arg1));
    }

    public A withNewFsType(StringBuilder arg1){
            return (A)withFsType(new String(arg1));
    }

    public A withNewFsType(StringBuffer arg1){
            return (A)withFsType(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildNodePublishSecretRef instead.
 * @return The buildable object.
 */
@Deprecated public V1LocalObjectReference getNodePublishSecretRef(){
            return this.nodePublishSecretRef!=null?this.nodePublishSecretRef.build():null;
    }

    public V1LocalObjectReference buildNodePublishSecretRef(){
            return this.nodePublishSecretRef!=null?this.nodePublishSecretRef.build():null;
    }

    public A withNodePublishSecretRef(V1LocalObjectReference nodePublishSecretRef){
            _visitables.get("nodePublishSecretRef").remove(this.nodePublishSecretRef);
            if (nodePublishSecretRef!=null){ this.nodePublishSecretRef= new V1LocalObjectReferenceBuilder(nodePublishSecretRef); _visitables.get("nodePublishSecretRef").add(this.nodePublishSecretRef);} return (A) this;
    }

    public Boolean hasNodePublishSecretRef(){
            return this.nodePublishSecretRef != null;
    }

    public V1CSIVolumeSourceFluent.NodePublishSecretRefNested<A> withNewNodePublishSecretRef(){
            return new NodePublishSecretRefNestedImpl();
    }

    public V1CSIVolumeSourceFluent.NodePublishSecretRefNested<A> withNewNodePublishSecretRefLike(V1LocalObjectReference item){
            return new NodePublishSecretRefNestedImpl(item);
    }

    public V1CSIVolumeSourceFluent.NodePublishSecretRefNested<A> editNodePublishSecretRef(){
            return withNewNodePublishSecretRefLike(getNodePublishSecretRef());
    }

    public V1CSIVolumeSourceFluent.NodePublishSecretRefNested<A> editOrNewNodePublishSecretRef(){
            return withNewNodePublishSecretRefLike(getNodePublishSecretRef() != null ? getNodePublishSecretRef(): new V1LocalObjectReferenceBuilder().build());
    }

    public V1CSIVolumeSourceFluent.NodePublishSecretRefNested<A> editOrNewNodePublishSecretRefLike(V1LocalObjectReference item){
            return withNewNodePublishSecretRefLike(getNodePublishSecretRef() != null ? getNodePublishSecretRef(): item);
    }

    public Boolean isReadOnly(){
            return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly){
            this.readOnly=readOnly; return (A) this;
    }

    public Boolean hasReadOnly(){
            return this.readOnly != null;
    }

    public A withNewReadOnly(String arg1){
            return (A)withReadOnly(new Boolean(arg1));
    }

    public A withNewReadOnly(boolean arg1){
            return (A)withReadOnly(new Boolean(arg1));
    }

    public A addToVolumeAttributes(String key,String value){
            if(this.volumeAttributes == null && key != null && value != null) { this.volumeAttributes = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.volumeAttributes.put(key, value);} return (A)this;
    }

    public A addToVolumeAttributes(Map<String,String> map){
            if(this.volumeAttributes == null && map != null) { this.volumeAttributes = new LinkedHashMap<String,String>(); }
            if(map != null) { this.volumeAttributes.putAll(map);} return (A)this;
    }

    public A removeFromVolumeAttributes(String key){
            if(this.volumeAttributes == null) { return (A) this; }
            if(key != null && this.volumeAttributes != null) {this.volumeAttributes.remove(key);} return (A)this;
    }

    public A removeFromVolumeAttributes(Map<String,String> map){
            if(this.volumeAttributes == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.volumeAttributes != null){this.volumeAttributes.remove(key);}}} return (A)this;
    }

    public Map<String,String> getVolumeAttributes(){
            return this.volumeAttributes;
    }

    public A withVolumeAttributes(Map<String,String> volumeAttributes){
            if (volumeAttributes == null) { this.volumeAttributes =  null;} else {this.volumeAttributes = new LinkedHashMap<String,String>(volumeAttributes);} return (A) this;
    }

    public Boolean hasVolumeAttributes(){
            return this.volumeAttributes != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1CSIVolumeSourceFluentImpl that = (V1CSIVolumeSourceFluentImpl) o;
            if (driver != null ? !driver.equals(that.driver) :that.driver != null) return false;
            if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
            if (nodePublishSecretRef != null ? !nodePublishSecretRef.equals(that.nodePublishSecretRef) :that.nodePublishSecretRef != null) return false;
            if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
            if (volumeAttributes != null ? !volumeAttributes.equals(that.volumeAttributes) :that.volumeAttributes != null) return false;
            return true;
    }


    public class NodePublishSecretRefNestedImpl<N> extends V1LocalObjectReferenceFluentImpl<V1CSIVolumeSourceFluent.NodePublishSecretRefNested<N>> implements V1CSIVolumeSourceFluent.NodePublishSecretRefNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LocalObjectReferenceBuilder builder;
    
            NodePublishSecretRefNestedImpl(V1LocalObjectReference item){
                    this.builder = new V1LocalObjectReferenceBuilder(this, item);
            }
            NodePublishSecretRefNestedImpl(){
                    this.builder = new V1LocalObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) V1CSIVolumeSourceFluentImpl.this.withNodePublishSecretRef(builder.build());
    }
    public N endNodePublishSecretRef(){
            return and();
    }

}


}
