package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class V1CustomResourceDefinitionStatusFluentImpl<A extends V1CustomResourceDefinitionStatusFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1CustomResourceDefinitionStatusFluent<A>{

    private V1CustomResourceDefinitionNamesBuilder acceptedNames;
    private List<V1CustomResourceDefinitionConditionBuilder> conditions;
    private List<String> storedVersions;

    public V1CustomResourceDefinitionStatusFluentImpl(){
    }
    public V1CustomResourceDefinitionStatusFluentImpl(V1CustomResourceDefinitionStatus instance){
            this.withAcceptedNames(instance.getAcceptedNames());

            this.withConditions(instance.getConditions());

            this.withStoredVersions(instance.getStoredVersions());

    }

    
/**
 * This method has been deprecated, please use method buildAcceptedNames instead.
 * @return The buildable object.
 */
@Deprecated public V1CustomResourceDefinitionNames getAcceptedNames(){
            return this.acceptedNames!=null?this.acceptedNames.build():null;
    }

    public V1CustomResourceDefinitionNames buildAcceptedNames(){
            return this.acceptedNames!=null?this.acceptedNames.build():null;
    }

    public A withAcceptedNames(V1CustomResourceDefinitionNames acceptedNames){
            _visitables.get("acceptedNames").remove(this.acceptedNames);
            if (acceptedNames!=null){ this.acceptedNames= new V1CustomResourceDefinitionNamesBuilder(acceptedNames); _visitables.get("acceptedNames").add(this.acceptedNames);} return (A) this;
    }

    public Boolean hasAcceptedNames(){
            return this.acceptedNames != null;
    }

    public V1CustomResourceDefinitionStatusFluent.AcceptedNamesNested<A> withNewAcceptedNames(){
            return new AcceptedNamesNestedImpl();
    }

    public V1CustomResourceDefinitionStatusFluent.AcceptedNamesNested<A> withNewAcceptedNamesLike(V1CustomResourceDefinitionNames item){
            return new AcceptedNamesNestedImpl(item);
    }

    public V1CustomResourceDefinitionStatusFluent.AcceptedNamesNested<A> editAcceptedNames(){
            return withNewAcceptedNamesLike(getAcceptedNames());
    }

    public V1CustomResourceDefinitionStatusFluent.AcceptedNamesNested<A> editOrNewAcceptedNames(){
            return withNewAcceptedNamesLike(getAcceptedNames() != null ? getAcceptedNames(): new V1CustomResourceDefinitionNamesBuilder().build());
    }

    public V1CustomResourceDefinitionStatusFluent.AcceptedNamesNested<A> editOrNewAcceptedNamesLike(V1CustomResourceDefinitionNames item){
            return withNewAcceptedNamesLike(getAcceptedNames() != null ? getAcceptedNames(): item);
    }

    public A addToConditions(int index,V1CustomResourceDefinitionCondition item){
            if (this.conditions == null) {this.conditions = new ArrayList<V1CustomResourceDefinitionConditionBuilder>();}
            V1CustomResourceDefinitionConditionBuilder builder = new V1CustomResourceDefinitionConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,V1CustomResourceDefinitionCondition item){
            if (this.conditions == null) {this.conditions = new ArrayList<V1CustomResourceDefinitionConditionBuilder>();}
            V1CustomResourceDefinitionConditionBuilder builder = new V1CustomResourceDefinitionConditionBuilder(item);
            if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
            if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
             return (A)this;
    }

    public A addToConditions(V1CustomResourceDefinitionCondition... items){
            if (this.conditions == null) {this.conditions = new ArrayList<V1CustomResourceDefinitionConditionBuilder>();}
            for (V1CustomResourceDefinitionCondition item : items) {V1CustomResourceDefinitionConditionBuilder builder = new V1CustomResourceDefinitionConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<V1CustomResourceDefinitionCondition> items){
            if (this.conditions == null) {this.conditions = new ArrayList<V1CustomResourceDefinitionConditionBuilder>();}
            for (V1CustomResourceDefinitionCondition item : items) {V1CustomResourceDefinitionConditionBuilder builder = new V1CustomResourceDefinitionConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(V1CustomResourceDefinitionCondition... items){
            for (V1CustomResourceDefinitionCondition item : items) {V1CustomResourceDefinitionConditionBuilder builder = new V1CustomResourceDefinitionConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<V1CustomResourceDefinitionCondition> items){
            for (V1CustomResourceDefinitionCondition item : items) {V1CustomResourceDefinitionConditionBuilder builder = new V1CustomResourceDefinitionConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(io.kubernetes.client.fluent.Predicate<V1CustomResourceDefinitionConditionBuilder> predicate){
            if (conditions == null) return (A) this;
            final Iterator<V1CustomResourceDefinitionConditionBuilder> each = conditions.iterator();
            final List visitables = _visitables.get("conditions");
            while (each.hasNext()) {
              V1CustomResourceDefinitionConditionBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1CustomResourceDefinitionCondition> getConditions(){
            return build(conditions);
    }

    public List<V1CustomResourceDefinitionCondition> buildConditions(){
            return build(conditions);
    }

    public V1CustomResourceDefinitionCondition buildCondition(int index){
            return this.conditions.get(index).build();
    }

    public V1CustomResourceDefinitionCondition buildFirstCondition(){
            return this.conditions.get(0).build();
    }

    public V1CustomResourceDefinitionCondition buildLastCondition(){
            return this.conditions.get(conditions.size() - 1).build();
    }

    public V1CustomResourceDefinitionCondition buildMatchingCondition(io.kubernetes.client.fluent.Predicate<V1CustomResourceDefinitionConditionBuilder> predicate){
            for (V1CustomResourceDefinitionConditionBuilder item: conditions) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(io.kubernetes.client.fluent.Predicate<V1CustomResourceDefinitionConditionBuilder> predicate){
            for (V1CustomResourceDefinitionConditionBuilder item: conditions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withConditions(List<V1CustomResourceDefinitionCondition> conditions){
            if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
            if (conditions != null) {this.conditions = new ArrayList<V1CustomResourceDefinitionConditionBuilder>(); for (V1CustomResourceDefinitionCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(V1CustomResourceDefinitionCondition... conditions){
            if (this.conditions != null) {this.conditions.clear();}
            if (conditions != null) {for (V1CustomResourceDefinitionCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions(){
            return conditions != null && !conditions.isEmpty();
    }

    public V1CustomResourceDefinitionStatusFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public V1CustomResourceDefinitionStatusFluent.ConditionsNested<A> addNewConditionLike(V1CustomResourceDefinitionCondition item){
            return new ConditionsNestedImpl(-1, item);
    }

    public V1CustomResourceDefinitionStatusFluent.ConditionsNested<A> setNewConditionLike(int index,V1CustomResourceDefinitionCondition item){
            return new ConditionsNestedImpl(index, item);
    }

    public V1CustomResourceDefinitionStatusFluent.ConditionsNested<A> editCondition(int index){
            if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public V1CustomResourceDefinitionStatusFluent.ConditionsNested<A> editFirstCondition(){
            if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
            return setNewConditionLike(0, buildCondition(0));
    }

    public V1CustomResourceDefinitionStatusFluent.ConditionsNested<A> editLastCondition(){
            int index = conditions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public V1CustomResourceDefinitionStatusFluent.ConditionsNested<A> editMatchingCondition(io.kubernetes.client.fluent.Predicate<V1CustomResourceDefinitionConditionBuilder> predicate){
            int index = -1;
            for (int i=0;i<conditions.size();i++) { 
            if (predicate.apply(conditions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public A addToStoredVersions(int index,String item){
            if (this.storedVersions == null) {this.storedVersions = new ArrayList<String>();}
            this.storedVersions.add(index, item);
            return (A)this;
    }

    public A setToStoredVersions(int index,String item){
            if (this.storedVersions == null) {this.storedVersions = new ArrayList<String>();}
            this.storedVersions.set(index, item); return (A)this;
    }

    public A addToStoredVersions(String... items){
            if (this.storedVersions == null) {this.storedVersions = new ArrayList<String>();}
            for (String item : items) {this.storedVersions.add(item);} return (A)this;
    }

    public A addAllToStoredVersions(Collection<String> items){
            if (this.storedVersions == null) {this.storedVersions = new ArrayList<String>();}
            for (String item : items) {this.storedVersions.add(item);} return (A)this;
    }

    public A removeFromStoredVersions(String... items){
            for (String item : items) {if (this.storedVersions!= null){ this.storedVersions.remove(item);}} return (A)this;
    }

    public A removeAllFromStoredVersions(Collection<String> items){
            for (String item : items) {if (this.storedVersions!= null){ this.storedVersions.remove(item);}} return (A)this;
    }

    public List<String> getStoredVersions(){
            return this.storedVersions;
    }

    public String getStoredVersion(int index){
            return this.storedVersions.get(index);
    }

    public String getFirstStoredVersion(){
            return this.storedVersions.get(0);
    }

    public String getLastStoredVersion(){
            return this.storedVersions.get(storedVersions.size() - 1);
    }

    public String getMatchingStoredVersion(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: storedVersions) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingStoredVersion(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: storedVersions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withStoredVersions(List<String> storedVersions){
            if (this.storedVersions != null) { _visitables.get("storedVersions").removeAll(this.storedVersions);}
            if (storedVersions != null) {this.storedVersions = new ArrayList<String>(); for (String item : storedVersions){this.addToStoredVersions(item);}} else { this.storedVersions = null;} return (A) this;
    }

    public A withStoredVersions(String... storedVersions){
            if (this.storedVersions != null) {this.storedVersions.clear();}
            if (storedVersions != null) {for (String item :storedVersions){ this.addToStoredVersions(item);}} return (A) this;
    }

    public Boolean hasStoredVersions(){
            return storedVersions != null && !storedVersions.isEmpty();
    }

    public A addNewStoredVersion(String arg1){
            return (A)addToStoredVersions(new String(arg1));
    }

    public A addNewStoredVersion(StringBuilder arg1){
            return (A)addToStoredVersions(new String(arg1));
    }

    public A addNewStoredVersion(StringBuffer arg1){
            return (A)addToStoredVersions(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1CustomResourceDefinitionStatusFluentImpl that = (V1CustomResourceDefinitionStatusFluentImpl) o;
            if (acceptedNames != null ? !acceptedNames.equals(that.acceptedNames) :that.acceptedNames != null) return false;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (storedVersions != null ? !storedVersions.equals(that.storedVersions) :that.storedVersions != null) return false;
            return true;
    }


    public class AcceptedNamesNestedImpl<N> extends V1CustomResourceDefinitionNamesFluentImpl<V1CustomResourceDefinitionStatusFluent.AcceptedNamesNested<N>> implements V1CustomResourceDefinitionStatusFluent.AcceptedNamesNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1CustomResourceDefinitionNamesBuilder builder;
    
            AcceptedNamesNestedImpl(V1CustomResourceDefinitionNames item){
                    this.builder = new V1CustomResourceDefinitionNamesBuilder(this, item);
            }
            AcceptedNamesNestedImpl(){
                    this.builder = new V1CustomResourceDefinitionNamesBuilder(this);
            }
    
    public N and(){
            return (N) V1CustomResourceDefinitionStatusFluentImpl.this.withAcceptedNames(builder.build());
    }
    public N endAcceptedNames(){
            return and();
    }

}
    public class ConditionsNestedImpl<N> extends V1CustomResourceDefinitionConditionFluentImpl<V1CustomResourceDefinitionStatusFluent.ConditionsNested<N>> implements V1CustomResourceDefinitionStatusFluent.ConditionsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1CustomResourceDefinitionConditionBuilder builder;
        private final int index;
    
            ConditionsNestedImpl(int index,V1CustomResourceDefinitionCondition item){
                    this.index = index;
                    this.builder = new V1CustomResourceDefinitionConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1CustomResourceDefinitionConditionBuilder(this);
            }
    
    public N and(){
            return (N) V1CustomResourceDefinitionStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition(){
            return and();
    }

}


}
