package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1HTTPGetActionBuilder extends V1HTTPGetActionFluentImpl<V1HTTPGetActionBuilder> implements VisitableBuilder<V1HTTPGetAction,V1HTTPGetActionBuilder>{

    V1HTTPGetActionFluent<?> fluent;
    Boolean validationEnabled;

    public V1HTTPGetActionBuilder(){
            this(true);
    }
    public V1HTTPGetActionBuilder(Boolean validationEnabled){
            this(new V1HTTPGetAction(), validationEnabled);
    }
    public V1HTTPGetActionBuilder(V1HTTPGetActionFluent<?> fluent){
            this(fluent, true);
    }
    public V1HTTPGetActionBuilder(V1HTTPGetActionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1HTTPGetAction(), validationEnabled);
    }
    public V1HTTPGetActionBuilder(V1HTTPGetActionFluent<?> fluent,V1HTTPGetAction instance){
            this(fluent, instance, true);
    }
    public V1HTTPGetActionBuilder(V1HTTPGetActionFluent<?> fluent,V1HTTPGetAction instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHost(instance.getHost());

            fluent.withHttpHeaders(instance.getHttpHeaders());

            fluent.withPath(instance.getPath());

            fluent.withPort(instance.getPort());

            fluent.withScheme(instance.getScheme());

            this.validationEnabled = validationEnabled; 
    }
    public V1HTTPGetActionBuilder(V1HTTPGetAction instance){
            this(instance,true);
    }
    public V1HTTPGetActionBuilder(V1HTTPGetAction instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHost(instance.getHost());

            this.withHttpHeaders(instance.getHttpHeaders());

            this.withPath(instance.getPath());

            this.withPort(instance.getPort());

            this.withScheme(instance.getScheme());

            this.validationEnabled = validationEnabled; 
    }

    public V1HTTPGetAction build(){
            V1HTTPGetAction buildable = new V1HTTPGetAction();
            buildable.setHost(fluent.getHost());
            buildable.setHttpHeaders(fluent.getHttpHeaders());
            buildable.setPath(fluent.getPath());
            buildable.setPort(fluent.getPort());
            buildable.setScheme(fluent.getScheme());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1HTTPGetActionBuilder that = (V1HTTPGetActionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
