package io.kubernetes.client.openapi.models;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V1ObjectFieldSelectorFluentImpl<A extends V1ObjectFieldSelectorFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1ObjectFieldSelectorFluent<A>{

    private String apiVersion;
    private String fieldPath;

    public V1ObjectFieldSelectorFluentImpl(){
    }
    public V1ObjectFieldSelectorFluentImpl(V1ObjectFieldSelector instance){
            this.withApiVersion(instance.getApiVersion());

            this.withFieldPath(instance.getFieldPath());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getFieldPath(){
            return this.fieldPath;
    }

    public A withFieldPath(String fieldPath){
            this.fieldPath=fieldPath; return (A) this;
    }

    public Boolean hasFieldPath(){
            return this.fieldPath != null;
    }

    public A withNewFieldPath(String arg1){
            return (A)withFieldPath(new String(arg1));
    }

    public A withNewFieldPath(StringBuilder arg1){
            return (A)withFieldPath(new String(arg1));
    }

    public A withNewFieldPath(StringBuffer arg1){
            return (A)withFieldPath(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1ObjectFieldSelectorFluentImpl that = (V1ObjectFieldSelectorFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (fieldPath != null ? !fieldPath.equals(that.fieldPath) :that.fieldPath != null) return false;
            return true;
    }




}
