package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1PodAffinityTermFluentImpl<A extends V1PodAffinityTermFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1PodAffinityTermFluent<A>{

    private V1LabelSelectorBuilder labelSelector;
    private List<String> namespaces;
    private String topologyKey;

    public V1PodAffinityTermFluentImpl(){
    }
    public V1PodAffinityTermFluentImpl(V1PodAffinityTerm instance){
            this.withLabelSelector(instance.getLabelSelector());

            this.withNamespaces(instance.getNamespaces());

            this.withTopologyKey(instance.getTopologyKey());

    }

    
/**
 * This method has been deprecated, please use method buildLabelSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getLabelSelector(){
            return this.labelSelector!=null?this.labelSelector.build():null;
    }

    public V1LabelSelector buildLabelSelector(){
            return this.labelSelector!=null?this.labelSelector.build():null;
    }

    public A withLabelSelector(V1LabelSelector labelSelector){
            _visitables.get("labelSelector").remove(this.labelSelector);
            if (labelSelector!=null){ this.labelSelector= new V1LabelSelectorBuilder(labelSelector); _visitables.get("labelSelector").add(this.labelSelector);} return (A) this;
    }

    public Boolean hasLabelSelector(){
            return this.labelSelector != null;
    }

    public V1PodAffinityTermFluent.LabelSelectorNested<A> withNewLabelSelector(){
            return new LabelSelectorNestedImpl();
    }

    public V1PodAffinityTermFluent.LabelSelectorNested<A> withNewLabelSelectorLike(V1LabelSelector item){
            return new LabelSelectorNestedImpl(item);
    }

    public V1PodAffinityTermFluent.LabelSelectorNested<A> editLabelSelector(){
            return withNewLabelSelectorLike(getLabelSelector());
    }

    public V1PodAffinityTermFluent.LabelSelectorNested<A> editOrNewLabelSelector(){
            return withNewLabelSelectorLike(getLabelSelector() != null ? getLabelSelector(): new V1LabelSelectorBuilder().build());
    }

    public V1PodAffinityTermFluent.LabelSelectorNested<A> editOrNewLabelSelectorLike(V1LabelSelector item){
            return withNewLabelSelectorLike(getLabelSelector() != null ? getLabelSelector(): item);
    }

    public A addToNamespaces(int index,String item){
            if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
            this.namespaces.add(index, item);
            return (A)this;
    }

    public A setToNamespaces(int index,String item){
            if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
            this.namespaces.set(index, item); return (A)this;
    }

    public A addToNamespaces(String... items){
            if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
            for (String item : items) {this.namespaces.add(item);} return (A)this;
    }

    public A addAllToNamespaces(Collection<String> items){
            if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
            for (String item : items) {this.namespaces.add(item);} return (A)this;
    }

    public A removeFromNamespaces(String... items){
            for (String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
    }

    public A removeAllFromNamespaces(Collection<String> items){
            for (String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
    }

    public List<String> getNamespaces(){
            return this.namespaces;
    }

    public String getNamespace(int index){
            return this.namespaces.get(index);
    }

    public String getFirstNamespace(){
            return this.namespaces.get(0);
    }

    public String getLastNamespace(){
            return this.namespaces.get(namespaces.size() - 1);
    }

    public String getMatchingNamespace(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: namespaces) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNamespace(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: namespaces) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withNamespaces(List<String> namespaces){
            if (this.namespaces != null) { _visitables.get("namespaces").removeAll(this.namespaces);}
            if (namespaces != null) {this.namespaces = new ArrayList<String>(); for (String item : namespaces){this.addToNamespaces(item);}} else { this.namespaces = null;} return (A) this;
    }

    public A withNamespaces(String... namespaces){
            if (this.namespaces != null) {this.namespaces.clear();}
            if (namespaces != null) {for (String item :namespaces){ this.addToNamespaces(item);}} return (A) this;
    }

    public Boolean hasNamespaces(){
            return namespaces != null && !namespaces.isEmpty();
    }

    public A addNewNamespace(String arg1){
            return (A)addToNamespaces(new String(arg1));
    }

    public A addNewNamespace(StringBuilder arg1){
            return (A)addToNamespaces(new String(arg1));
    }

    public A addNewNamespace(StringBuffer arg1){
            return (A)addToNamespaces(new String(arg1));
    }

    public String getTopologyKey(){
            return this.topologyKey;
    }

    public A withTopologyKey(String topologyKey){
            this.topologyKey=topologyKey; return (A) this;
    }

    public Boolean hasTopologyKey(){
            return this.topologyKey != null;
    }

    public A withNewTopologyKey(String arg1){
            return (A)withTopologyKey(new String(arg1));
    }

    public A withNewTopologyKey(StringBuilder arg1){
            return (A)withTopologyKey(new String(arg1));
    }

    public A withNewTopologyKey(StringBuffer arg1){
            return (A)withTopologyKey(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1PodAffinityTermFluentImpl that = (V1PodAffinityTermFluentImpl) o;
            if (labelSelector != null ? !labelSelector.equals(that.labelSelector) :that.labelSelector != null) return false;
            if (namespaces != null ? !namespaces.equals(that.namespaces) :that.namespaces != null) return false;
            if (topologyKey != null ? !topologyKey.equals(that.topologyKey) :that.topologyKey != null) return false;
            return true;
    }


    public class LabelSelectorNestedImpl<N> extends V1LabelSelectorFluentImpl<V1PodAffinityTermFluent.LabelSelectorNested<N>> implements V1PodAffinityTermFluent.LabelSelectorNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LabelSelectorBuilder builder;
    
            LabelSelectorNestedImpl(V1LabelSelector item){
                    this.builder = new V1LabelSelectorBuilder(this, item);
            }
            LabelSelectorNestedImpl(){
                    this.builder = new V1LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) V1PodAffinityTermFluentImpl.this.withLabelSelector(builder.build());
    }
    public N endLabelSelector(){
            return and();
    }

}


}
