package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1PodAntiAffinityBuilder extends V1PodAntiAffinityFluentImpl<V1PodAntiAffinityBuilder> implements VisitableBuilder<V1PodAntiAffinity,V1PodAntiAffinityBuilder>{

    V1PodAntiAffinityFluent<?> fluent;
    Boolean validationEnabled;

    public V1PodAntiAffinityBuilder(){
            this(true);
    }
    public V1PodAntiAffinityBuilder(Boolean validationEnabled){
            this(new V1PodAntiAffinity(), validationEnabled);
    }
    public V1PodAntiAffinityBuilder(V1PodAntiAffinityFluent<?> fluent){
            this(fluent, true);
    }
    public V1PodAntiAffinityBuilder(V1PodAntiAffinityFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1PodAntiAffinity(), validationEnabled);
    }
    public V1PodAntiAffinityBuilder(V1PodAntiAffinityFluent<?> fluent,V1PodAntiAffinity instance){
            this(fluent, instance, true);
    }
    public V1PodAntiAffinityBuilder(V1PodAntiAffinityFluent<?> fluent,V1PodAntiAffinity instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution());

            fluent.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution());

            this.validationEnabled = validationEnabled; 
    }
    public V1PodAntiAffinityBuilder(V1PodAntiAffinity instance){
            this(instance,true);
    }
    public V1PodAntiAffinityBuilder(V1PodAntiAffinity instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution());

            this.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution());

            this.validationEnabled = validationEnabled; 
    }

    public V1PodAntiAffinity build(){
            V1PodAntiAffinity buildable = new V1PodAntiAffinity();
            buildable.setPreferredDuringSchedulingIgnoredDuringExecution(fluent.getPreferredDuringSchedulingIgnoredDuringExecution());
            buildable.setRequiredDuringSchedulingIgnoredDuringExecution(fluent.getRequiredDuringSchedulingIgnoredDuringExecution());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1PodAntiAffinityBuilder that = (V1PodAntiAffinityBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
