package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1LimitResponseBuilder extends V1alpha1LimitResponseFluentImpl<V1alpha1LimitResponseBuilder> implements VisitableBuilder<V1alpha1LimitResponse,V1alpha1LimitResponseBuilder>{

    V1alpha1LimitResponseFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1LimitResponseBuilder(){
            this(true);
    }
    public V1alpha1LimitResponseBuilder(Boolean validationEnabled){
            this(new V1alpha1LimitResponse(), validationEnabled);
    }
    public V1alpha1LimitResponseBuilder(V1alpha1LimitResponseFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1LimitResponseBuilder(V1alpha1LimitResponseFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1LimitResponse(), validationEnabled);
    }
    public V1alpha1LimitResponseBuilder(V1alpha1LimitResponseFluent<?> fluent,V1alpha1LimitResponse instance){
            this(fluent, instance, true);
    }
    public V1alpha1LimitResponseBuilder(V1alpha1LimitResponseFluent<?> fluent,V1alpha1LimitResponse instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withQueuing(instance.getQueuing());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1LimitResponseBuilder(V1alpha1LimitResponse instance){
            this(instance,true);
    }
    public V1alpha1LimitResponseBuilder(V1alpha1LimitResponse instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withQueuing(instance.getQueuing());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1LimitResponse build(){
            V1alpha1LimitResponse buildable = new V1alpha1LimitResponse();
            buildable.setQueuing(fluent.getQueuing());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1LimitResponseBuilder that = (V1alpha1LimitResponseBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
