package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1AllowedHostPathBuilder extends V1beta1AllowedHostPathFluentImpl<V1beta1AllowedHostPathBuilder> implements VisitableBuilder<V1beta1AllowedHostPath,V1beta1AllowedHostPathBuilder>{

    V1beta1AllowedHostPathFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1AllowedHostPathBuilder(){
            this(true);
    }
    public V1beta1AllowedHostPathBuilder(Boolean validationEnabled){
            this(new V1beta1AllowedHostPath(), validationEnabled);
    }
    public V1beta1AllowedHostPathBuilder(V1beta1AllowedHostPathFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1AllowedHostPathBuilder(V1beta1AllowedHostPathFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1AllowedHostPath(), validationEnabled);
    }
    public V1beta1AllowedHostPathBuilder(V1beta1AllowedHostPathFluent<?> fluent,V1beta1AllowedHostPath instance){
            this(fluent, instance, true);
    }
    public V1beta1AllowedHostPathBuilder(V1beta1AllowedHostPathFluent<?> fluent,V1beta1AllowedHostPath instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPathPrefix(instance.getPathPrefix());

            fluent.withReadOnly(instance.getReadOnly());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1AllowedHostPathBuilder(V1beta1AllowedHostPath instance){
            this(instance,true);
    }
    public V1beta1AllowedHostPathBuilder(V1beta1AllowedHostPath instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPathPrefix(instance.getPathPrefix());

            this.withReadOnly(instance.getReadOnly());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1AllowedHostPath build(){
            V1beta1AllowedHostPath buildable = new V1beta1AllowedHostPath();
            buildable.setPathPrefix(fluent.getPathPrefix());
            buildable.setReadOnly(fluent.isReadOnly());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1AllowedHostPathBuilder that = (V1beta1AllowedHostPathBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
