package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1CustomResourceConversionBuilder extends V1beta1CustomResourceConversionFluentImpl<V1beta1CustomResourceConversionBuilder> implements VisitableBuilder<V1beta1CustomResourceConversion,V1beta1CustomResourceConversionBuilder>{

    V1beta1CustomResourceConversionFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1CustomResourceConversionBuilder(){
            this(true);
    }
    public V1beta1CustomResourceConversionBuilder(Boolean validationEnabled){
            this(new V1beta1CustomResourceConversion(), validationEnabled);
    }
    public V1beta1CustomResourceConversionBuilder(V1beta1CustomResourceConversionFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1CustomResourceConversionBuilder(V1beta1CustomResourceConversionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1CustomResourceConversion(), validationEnabled);
    }
    public V1beta1CustomResourceConversionBuilder(V1beta1CustomResourceConversionFluent<?> fluent,V1beta1CustomResourceConversion instance){
            this(fluent, instance, true);
    }
    public V1beta1CustomResourceConversionBuilder(V1beta1CustomResourceConversionFluent<?> fluent,V1beta1CustomResourceConversion instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConversionReviewVersions(instance.getConversionReviewVersions());

            fluent.withStrategy(instance.getStrategy());

            fluent.withWebhookClientConfig(instance.getWebhookClientConfig());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1CustomResourceConversionBuilder(V1beta1CustomResourceConversion instance){
            this(instance,true);
    }
    public V1beta1CustomResourceConversionBuilder(V1beta1CustomResourceConversion instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConversionReviewVersions(instance.getConversionReviewVersions());

            this.withStrategy(instance.getStrategy());

            this.withWebhookClientConfig(instance.getWebhookClientConfig());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1CustomResourceConversion build(){
            V1beta1CustomResourceConversion buildable = new V1beta1CustomResourceConversion();
            buildable.setConversionReviewVersions(fluent.getConversionReviewVersions());
            buildable.setStrategy(fluent.getStrategy());
            buildable.setWebhookClientConfig(fluent.getWebhookClientConfig());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1CustomResourceConversionBuilder that = (V1beta1CustomResourceConversionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
