package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1FSGroupStrategyOptionsBuilder extends V1beta1FSGroupStrategyOptionsFluentImpl<V1beta1FSGroupStrategyOptionsBuilder> implements VisitableBuilder<V1beta1FSGroupStrategyOptions,V1beta1FSGroupStrategyOptionsBuilder>{

    V1beta1FSGroupStrategyOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1FSGroupStrategyOptionsBuilder(){
            this(true);
    }
    public V1beta1FSGroupStrategyOptionsBuilder(Boolean validationEnabled){
            this(new V1beta1FSGroupStrategyOptions(), validationEnabled);
    }
    public V1beta1FSGroupStrategyOptionsBuilder(V1beta1FSGroupStrategyOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1FSGroupStrategyOptionsBuilder(V1beta1FSGroupStrategyOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1FSGroupStrategyOptions(), validationEnabled);
    }
    public V1beta1FSGroupStrategyOptionsBuilder(V1beta1FSGroupStrategyOptionsFluent<?> fluent,V1beta1FSGroupStrategyOptions instance){
            this(fluent, instance, true);
    }
    public V1beta1FSGroupStrategyOptionsBuilder(V1beta1FSGroupStrategyOptionsFluent<?> fluent,V1beta1FSGroupStrategyOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRanges(instance.getRanges());

            fluent.withRule(instance.getRule());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1FSGroupStrategyOptionsBuilder(V1beta1FSGroupStrategyOptions instance){
            this(instance,true);
    }
    public V1beta1FSGroupStrategyOptionsBuilder(V1beta1FSGroupStrategyOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRanges(instance.getRanges());

            this.withRule(instance.getRule());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1FSGroupStrategyOptions build(){
            V1beta1FSGroupStrategyOptions buildable = new V1beta1FSGroupStrategyOptions();
            buildable.setRanges(fluent.getRanges());
            buildable.setRule(fluent.getRule());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1FSGroupStrategyOptionsBuilder that = (V1beta1FSGroupStrategyOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
