package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1SubjectRulesReviewStatusBuilder extends V1beta1SubjectRulesReviewStatusFluentImpl<V1beta1SubjectRulesReviewStatusBuilder> implements VisitableBuilder<V1beta1SubjectRulesReviewStatus,V1beta1SubjectRulesReviewStatusBuilder>{

    V1beta1SubjectRulesReviewStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1SubjectRulesReviewStatusBuilder(){
            this(true);
    }
    public V1beta1SubjectRulesReviewStatusBuilder(Boolean validationEnabled){
            this(new V1beta1SubjectRulesReviewStatus(), validationEnabled);
    }
    public V1beta1SubjectRulesReviewStatusBuilder(V1beta1SubjectRulesReviewStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1SubjectRulesReviewStatusBuilder(V1beta1SubjectRulesReviewStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1SubjectRulesReviewStatus(), validationEnabled);
    }
    public V1beta1SubjectRulesReviewStatusBuilder(V1beta1SubjectRulesReviewStatusFluent<?> fluent,V1beta1SubjectRulesReviewStatus instance){
            this(fluent, instance, true);
    }
    public V1beta1SubjectRulesReviewStatusBuilder(V1beta1SubjectRulesReviewStatusFluent<?> fluent,V1beta1SubjectRulesReviewStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withEvaluationError(instance.getEvaluationError());

            fluent.withIncomplete(instance.getIncomplete());

            fluent.withNonResourceRules(instance.getNonResourceRules());

            fluent.withResourceRules(instance.getResourceRules());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1SubjectRulesReviewStatusBuilder(V1beta1SubjectRulesReviewStatus instance){
            this(instance,true);
    }
    public V1beta1SubjectRulesReviewStatusBuilder(V1beta1SubjectRulesReviewStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withEvaluationError(instance.getEvaluationError());

            this.withIncomplete(instance.getIncomplete());

            this.withNonResourceRules(instance.getNonResourceRules());

            this.withResourceRules(instance.getResourceRules());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1SubjectRulesReviewStatus build(){
            V1beta1SubjectRulesReviewStatus buildable = new V1beta1SubjectRulesReviewStatus();
            buildable.setEvaluationError(fluent.getEvaluationError());
            buildable.setIncomplete(fluent.isIncomplete());
            buildable.setNonResourceRules(fluent.getNonResourceRules());
            buildable.setResourceRules(fluent.getResourceRules());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1SubjectRulesReviewStatusBuilder that = (V1beta1SubjectRulesReviewStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
