package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V2beta2HorizontalPodAutoscalerBehaviorBuilder extends V2beta2HorizontalPodAutoscalerBehaviorFluentImpl<V2beta2HorizontalPodAutoscalerBehaviorBuilder> implements VisitableBuilder<V2beta2HorizontalPodAutoscalerBehavior,V2beta2HorizontalPodAutoscalerBehaviorBuilder>{

    V2beta2HorizontalPodAutoscalerBehaviorFluent<?> fluent;
    Boolean validationEnabled;

    public V2beta2HorizontalPodAutoscalerBehaviorBuilder(){
            this(true);
    }
    public V2beta2HorizontalPodAutoscalerBehaviorBuilder(Boolean validationEnabled){
            this(new V2beta2HorizontalPodAutoscalerBehavior(), validationEnabled);
    }
    public V2beta2HorizontalPodAutoscalerBehaviorBuilder(V2beta2HorizontalPodAutoscalerBehaviorFluent<?> fluent){
            this(fluent, true);
    }
    public V2beta2HorizontalPodAutoscalerBehaviorBuilder(V2beta2HorizontalPodAutoscalerBehaviorFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V2beta2HorizontalPodAutoscalerBehavior(), validationEnabled);
    }
    public V2beta2HorizontalPodAutoscalerBehaviorBuilder(V2beta2HorizontalPodAutoscalerBehaviorFluent<?> fluent,V2beta2HorizontalPodAutoscalerBehavior instance){
            this(fluent, instance, true);
    }
    public V2beta2HorizontalPodAutoscalerBehaviorBuilder(V2beta2HorizontalPodAutoscalerBehaviorFluent<?> fluent,V2beta2HorizontalPodAutoscalerBehavior instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withScaleDown(instance.getScaleDown());

            fluent.withScaleUp(instance.getScaleUp());

            this.validationEnabled = validationEnabled; 
    }
    public V2beta2HorizontalPodAutoscalerBehaviorBuilder(V2beta2HorizontalPodAutoscalerBehavior instance){
            this(instance,true);
    }
    public V2beta2HorizontalPodAutoscalerBehaviorBuilder(V2beta2HorizontalPodAutoscalerBehavior instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withScaleDown(instance.getScaleDown());

            this.withScaleUp(instance.getScaleUp());

            this.validationEnabled = validationEnabled; 
    }

    public V2beta2HorizontalPodAutoscalerBehavior build(){
            V2beta2HorizontalPodAutoscalerBehavior buildable = new V2beta2HorizontalPodAutoscalerBehavior();
            buildable.setScaleDown(fluent.getScaleDown());
            buildable.setScaleUp(fluent.getScaleUp());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V2beta2HorizontalPodAutoscalerBehaviorBuilder that = (V2beta2HorizontalPodAutoscalerBehaviorBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
